/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpceConfigurationsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListVpceConfigurationsResponse.Builder, ListVpceConfigurationsResponse> {
    private final List<VPCEConfiguration> vpceConfigurations;

    private final String nextToken;

    private ListVpceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.vpceConfigurations = builder.vpceConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint
     *         configuration.
     */
    public List<VPCEConfiguration> vpceConfigurations() {
        return vpceConfigurations;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpceConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpceConfigurationsResponse)) {
            return false;
        }
        ListVpceConfigurationsResponse other = (ListVpceConfigurationsResponse) obj;
        return Objects.equals(vpceConfigurations(), other.vpceConfigurations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListVpceConfigurationsResponse").add("VpceConfigurations", vpceConfigurations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceConfigurations":
            return Optional.ofNullable(clazz.cast(vpceConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, ListVpceConfigurationsResponse> {
        /**
         * <p>
         * An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint
         * configuration.
         * </p>
         * 
         * @param vpceConfigurations
         *        An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurations(Collection<VPCEConfiguration> vpceConfigurations);

        /**
         * <p>
         * An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint
         * configuration.
         * </p>
         * 
         * @param vpceConfigurations
         *        An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceConfigurations(VPCEConfiguration... vpceConfigurations);

        /**
         * <p>
         * An array of <code>VPCEConfiguration</code> objects containing information about your VPC endpoint
         * configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VPCEConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<VPCEConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VPCEConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #vpceConfigurations(List<VPCEConfiguration>)}.
         * 
         * @param vpceConfigurations
         *        a consumer that will call methods on {@link List<VPCEConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpceConfigurations(List<VPCEConfiguration>)
         */
        Builder vpceConfigurations(Consumer<VPCEConfiguration.Builder>... vpceConfigurations);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<VPCEConfiguration> vpceConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpceConfigurationsResponse model) {
            super(model);
            vpceConfigurations(model.vpceConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<VPCEConfiguration.Builder> getVpceConfigurations() {
            return vpceConfigurations != null ? vpceConfigurations.stream().map(VPCEConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpceConfigurations(Collection<VPCEConfiguration> vpceConfigurations) {
            this.vpceConfigurations = VPCEConfigurationsCopier.copy(vpceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurations(VPCEConfiguration... vpceConfigurations) {
            vpceConfigurations(Arrays.asList(vpceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurations(Consumer<VPCEConfiguration.Builder>... vpceConfigurations) {
            vpceConfigurations(Stream.of(vpceConfigurations).map(c -> VPCEConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVpceConfigurations(Collection<VPCEConfiguration.BuilderImpl> vpceConfigurations) {
            this.vpceConfigurations = VPCEConfigurationsCopier.copyFromBuilder(vpceConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListVpceConfigurationsResponse build() {
            return new ListVpceConfigurationsResponse(this);
        }
    }
}
