/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.MonetaryAmountMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A number representing the monetary amount for an offering or transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonetaryAmount implements StructuredPojo, ToCopyableBuilder<MonetaryAmount.Builder, MonetaryAmount> {
    private final Double amount;

    private final String currencyCode;

    private MonetaryAmount(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * The numerical amount of an offering or transaction.
     * </p>
     * 
     * @return The numerical amount of an offering or transaction.
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
     * @see CurrencyCode
     */
    public CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
     * @see CurrencyCode
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonetaryAmount)) {
            return false;
        }
        MonetaryAmount other = (MonetaryAmount) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("MonetaryAmount").add("Amount", amount()).add("CurrencyCode", currencyCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MonetaryAmountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MonetaryAmount> {
        /**
         * <p>
         * The numerical amount of an offering or transaction.
         * </p>
         * 
         * @param amount
         *        The numerical amount of an offering or transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
         * </p>
         * 
         * @param currencyCode
         *        The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
         * </p>
         * 
         * @param currencyCode
         *        The currency code of a monetary amount. For example, <code>USD</code> means "U.S. dollars."
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(CurrencyCode currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private Double amount;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(MonetaryAmount model) {
            amount(model.amount);
            currencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public MonetaryAmount build() {
            return new MonetaryAmount(this);
        }
    }
}
