/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RadiosMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the set of radios and their states on a device. Examples of radios include Wi-Fi, GPS, Bluetooth, and NFC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Radios implements StructuredPojo, ToCopyableBuilder<Radios.Builder, Radios> {
    private final Boolean wifi;

    private final Boolean bluetooth;

    private final Boolean nfc;

    private final Boolean gps;

    private Radios(BuilderImpl builder) {
        this.wifi = builder.wifi;
        this.bluetooth = builder.bluetooth;
        this.nfc = builder.nfc;
        this.gps = builder.gps;
    }

    /**
     * <p>
     * True if Wi-Fi is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if Wi-Fi is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean wifi() {
        return wifi;
    }

    /**
     * <p>
     * True if Bluetooth is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if Bluetooth is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean bluetooth() {
        return bluetooth;
    }

    /**
     * <p>
     * True if NFC is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if NFC is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean nfc() {
        return nfc;
    }

    /**
     * <p>
     * True if GPS is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if GPS is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean gps() {
        return gps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wifi());
        hashCode = 31 * hashCode + Objects.hashCode(bluetooth());
        hashCode = 31 * hashCode + Objects.hashCode(nfc());
        hashCode = 31 * hashCode + Objects.hashCode(gps());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Radios)) {
            return false;
        }
        Radios other = (Radios) obj;
        return Objects.equals(wifi(), other.wifi()) && Objects.equals(bluetooth(), other.bluetooth())
                && Objects.equals(nfc(), other.nfc()) && Objects.equals(gps(), other.gps());
    }

    @Override
    public String toString() {
        return ToString.builder("Radios").add("Wifi", wifi()).add("Bluetooth", bluetooth()).add("Nfc", nfc()).add("Gps", gps())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "wifi":
            return Optional.ofNullable(clazz.cast(wifi()));
        case "bluetooth":
            return Optional.ofNullable(clazz.cast(bluetooth()));
        case "nfc":
            return Optional.ofNullable(clazz.cast(nfc()));
        case "gps":
            return Optional.ofNullable(clazz.cast(gps()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RadiosMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Radios> {
        /**
         * <p>
         * True if Wi-Fi is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param wifi
         *        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wifi(Boolean wifi);

        /**
         * <p>
         * True if Bluetooth is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param bluetooth
         *        True if Bluetooth is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bluetooth(Boolean bluetooth);

        /**
         * <p>
         * True if NFC is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param nfc
         *        True if NFC is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfc(Boolean nfc);

        /**
         * <p>
         * True if GPS is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param gps
         *        True if GPS is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gps(Boolean gps);
    }

    static final class BuilderImpl implements Builder {
        private Boolean wifi;

        private Boolean bluetooth;

        private Boolean nfc;

        private Boolean gps;

        private BuilderImpl() {
        }

        private BuilderImpl(Radios model) {
            wifi(model.wifi);
            bluetooth(model.bluetooth);
            nfc(model.nfc);
            gps(model.gps);
        }

        public final Boolean getWifi() {
            return wifi;
        }

        @Override
        public final Builder wifi(Boolean wifi) {
            this.wifi = wifi;
            return this;
        }

        public final void setWifi(Boolean wifi) {
            this.wifi = wifi;
        }

        public final Boolean getBluetooth() {
            return bluetooth;
        }

        @Override
        public final Builder bluetooth(Boolean bluetooth) {
            this.bluetooth = bluetooth;
            return this;
        }

        public final void setBluetooth(Boolean bluetooth) {
            this.bluetooth = bluetooth;
        }

        public final Boolean getNfc() {
            return nfc;
        }

        @Override
        public final Builder nfc(Boolean nfc) {
            this.nfc = nfc;
            return this;
        }

        public final void setNfc(Boolean nfc) {
            this.nfc = nfc;
        }

        public final Boolean getGps() {
            return gps;
        }

        @Override
        public final Builder gps(Boolean gps) {
            this.gps = gps;
            return this;
        }

        public final void setGps(Boolean gps) {
            this.gps = gps;
        }

        @Override
        public Radios build() {
            return new Radios(this);
        }
    }
}
