/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request representing an offering renewal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewOfferingRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<RenewOfferingRequest.Builder, RenewOfferingRequest> {
    private final String offeringId;

    private final Integer quantity;

    private RenewOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.offeringId = builder.offeringId;
        this.quantity = builder.quantity;
    }

    /**
     * <p>
     * The ID of a request to renew an offering.
     * </p>
     * 
     * @return The ID of a request to renew an offering.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The quantity requested in an offering renewal.
     * </p>
     * 
     * @return The quantity requested in an offering renewal.
     */
    public Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewOfferingRequest)) {
            return false;
        }
        RenewOfferingRequest other = (RenewOfferingRequest) obj;
        return Objects.equals(offeringId(), other.offeringId()) && Objects.equals(quantity(), other.quantity());
    }

    @Override
    public String toString() {
        return ToString.builder("RenewOfferingRequest").add("OfferingId", offeringId()).add("Quantity", quantity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, RenewOfferingRequest> {
        /**
         * <p>
         * The ID of a request to renew an offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of a request to renew an offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The quantity requested in an offering renewal.
         * </p>
         * 
         * @param quantity
         *        The quantity requested in an offering renewal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String offeringId;

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewOfferingRequest model) {
            super(model);
            offeringId(model.offeringId);
            quantity(model.quantity);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenewOfferingRequest build() {
            return new RenewOfferingRequest(this);
        }
    }
}
