/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition for a device pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements StructuredPojo, ToCopyableBuilder<Rule.Builder, Rule> {
    private final String attribute;

    private final String operator;

    private final String value;

    private Rule(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_LABELS: The label of the device instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_LABELS: The label of the device instance.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public DeviceAttribute attribute() {
        return DeviceAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_LABELS: The label of the device instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_LABELS: The label of the device instance.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The rule's operator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * EQUALS: The equals operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * GREATER_THAN: The greater-than operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN: The in operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * LESS_THAN: The less-than operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_IN: The not-in operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONTAINS: The contains operator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The rule's operator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         EQUALS: The equals operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GREATER_THAN: The greater-than operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN: The in operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LESS_THAN: The less-than operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_IN: The not-in operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONTAINS: The contains operator.
     *         </p>
     *         </li>
     * @see RuleOperator
     */
    public RuleOperator operator() {
        return RuleOperator.fromValue(operator);
    }

    /**
     * <p>
     * The rule's operator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * EQUALS: The equals operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * GREATER_THAN: The greater-than operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN: The in operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * LESS_THAN: The less-than operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_IN: The not-in operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONTAINS: The contains operator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The rule's operator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         EQUALS: The equals operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GREATER_THAN: The greater-than operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN: The in operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LESS_THAN: The less-than operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_IN: The not-in operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONTAINS: The contains operator.
     *         </p>
     *         </li>
     * @see RuleOperator
     */
    public String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The rule's value.
     * </p>
     * 
     * @return The rule's value.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("Rule").add("Attribute", attributeAsString()).add("Operator", operatorAsString())
                .add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_LABELS: The label of the device instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attribute
         *        The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_LABELS: The label of the device instance.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_LABELS: The label of the device instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attribute
         *        The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_LABELS: The label of the device instance.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder attribute(DeviceAttribute attribute);

        /**
         * <p>
         * The rule's operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EQUALS: The equals operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * GREATER_THAN: The greater-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN: The in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * LESS_THAN: The less-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_IN: The not-in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTAINS: The contains operator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operator
         *        The rule's operator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        EQUALS: The equals operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GREATER_THAN: The greater-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN: The in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LESS_THAN: The less-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_IN: The not-in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTAINS: The contains operator.
         *        </p>
         *        </li>
         * @see RuleOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The rule's operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EQUALS: The equals operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * GREATER_THAN: The greater-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN: The in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * LESS_THAN: The less-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_IN: The not-in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTAINS: The contains operator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operator
         *        The rule's operator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        EQUALS: The equals operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GREATER_THAN: The greater-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN: The in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LESS_THAN: The less-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_IN: The not-in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTAINS: The contains operator.
         *        </p>
         *        </li>
         * @see RuleOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOperator
         */
        Builder operator(RuleOperator operator);

        /**
         * <p>
         * The rule's value.
         * </p>
         * 
         * @param value
         *        The rule's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            attribute(model.attribute);
            operator(model.operator);
            value(model.value);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(DeviceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleOperator operator) {
            this.operator(operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }
    }
}
