/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunTestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents additional test settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleRunTest implements StructuredPojo, ToCopyableBuilder<ScheduleRunTest.Builder, ScheduleRunTest> {
    private final String type;

    private final String testPackageArn;

    private final String testSpecArn;

    private final String filter;

    private final Map<String, String> parameters;

    private ScheduleRunTest(BuilderImpl builder) {
        this.type = builder.type;
        this.testPackageArn = builder.testPackageArn;
        this.testSpecArn = builder.testSpecArn;
        this.filter = builder.filter;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The test's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The test's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The test's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The test's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ARN of the uploaded test that will be run.
     * </p>
     * 
     * @return The ARN of the uploaded test that will be run.
     */
    public String testPackageArn() {
        return testPackageArn;
    }

    /**
     * <p>
     * The ARN of the YAML-formatted test specification.
     * </p>
     * 
     * @return The ARN of the YAML-formatted test specification.
     */
    public String testSpecArn() {
        return testSpecArn;
    }

    /**
     * <p>
     * The test's filter.
     * </p>
     * 
     * @return The test's filter.
     */
    public String filter() {
        return filter;
    }

    /**
     * <p>
     * The test's parameters, such as the following test framework parameters and fixture settings:
     * </p>
     * <p>
     * For Calabash tests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * profile: A cucumber profile, for example, "my_profile_name".
     * </p>
     * </li>
     * <li>
     * <p>
     * tags: You can limit execution to features or scenarios that have (or don't have) certain tags, for example,
     * "@smoke" or "@smoke,~@wip".
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Appium tests (all types):
     * </p>
     * <ul>
     * <li>
     * <p>
     * appium_version: The Appium version. Currently supported values are "1.4.16", "1.6.3", "latest", and "default".
     * </p>
     * <ul>
     * <li>
     * <p>
     * “latest” will run the latest Appium version supported by Device Farm (1.6.3).
     * </p>
     * </li>
     * <li>
     * <p>
     * For “default”, Device Farm will choose a compatible version of Appium for the device. The current behavior is to
     * run 1.4.16 on Android devices and iOS 9 and earlier, 1.6.3 for iOS 10 and later.
     * </p>
     * </li>
     * <li>
     * <p>
     * This behavior is subject to change.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For Fuzz tests (Android only):
     * </p>
     * <ul>
     * <li>
     * <p>
     * event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
     * </p>
     * </li>
     * <li>
     * <p>
     * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
     * </p>
     * </li>
     * <li>
     * <p>
     * seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical
     * event sequences.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Explorer tests:
     * </p>
     * <ul>
     * <li>
     * <p>
     * username: A username to use if the Explorer encounters a login form. If not supplied, no username will be
     * inserted.
     * </p>
     * </li>
     * <li>
     * <p>
     * password: A password to use if the Explorer encounters a login form. If not supplied, no password will be
     * inserted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For Instrumentation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * filter: A test filter string. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running a single test case: "com.android.abc.Test1"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a single test: "com.android.abc.Test1#smoke"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For XCTest and XCTestUI:
     * </p>
     * <ul>
     * <li>
     * <p>
     * filter: A test filter string. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running a single test class: "LoginTests"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a multiple test classes: "LoginTests,SmokeTests"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a single test: "LoginTests/testValid"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For UIAutomator:
     * </p>
     * <ul>
     * <li>
     * <p>
     * filter: A test filter string. Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running a single test case: "com.android.abc.Test1"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running a single test: "com.android.abc.Test1#smoke"
     * </p>
     * </li>
     * <li>
     * <p>
     * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The test's parameters, such as the following test framework parameters and fixture settings:</p>
     *         <p>
     *         For Calabash tests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         profile: A cucumber profile, for example, "my_profile_name".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         tags: You can limit execution to features or scenarios that have (or don't have) certain tags, for
     *         example, "@smoke" or "@smoke,~@wip".
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Appium tests (all types):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         appium_version: The Appium version. Currently supported values are "1.4.16", "1.6.3", "latest", and
     *         "default".
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         “latest” will run the latest Appium version supported by Device Farm (1.6.3).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For “default”, Device Farm will choose a compatible version of Appium for the device. The current
     *         behavior is to run 1.4.16 on Android devices and iOS 9 and earlier, 1.6.3 for iOS 10 and later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This behavior is subject to change.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         For Fuzz tests (Android only):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures
     *         identical event sequences.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Explorer tests:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         username: A username to use if the Explorer encounters a login form. If not supplied, no username will be
     *         inserted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         password: A password to use if the Explorer encounters a login form. If not supplied, no password will be
     *         inserted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For Instrumentation:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         filter: A test filter string. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running a single test case: "com.android.abc.Test1"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a single test: "com.android.abc.Test1#smoke"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         For XCTest and XCTestUI:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         filter: A test filter string. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running a single test class: "LoginTests"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a multiple test classes: "LoginTests,SmokeTests"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a single test: "LoginTests/testValid"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         For UIAutomator:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         filter: A test filter string. Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running a single test case: "com.android.abc.Test1"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running a single test: "com.android.abc.Test1#smoke"
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(testPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(testSpecArn());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunTest)) {
            return false;
        }
        ScheduleRunTest other = (ScheduleRunTest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(testPackageArn(), other.testPackageArn())
                && Objects.equals(testSpecArn(), other.testSpecArn()) && Objects.equals(filter(), other.filter())
                && Objects.equals(parameters(), other.parameters());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduleRunTest").add("Type", typeAsString()).add("TestPackageArn", testPackageArn())
                .add("TestSpecArn", testSpecArn()).add("Filter", filter()).add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "testPackageArn":
            return Optional.ofNullable(clazz.cast(testPackageArn()));
        case "testSpecArn":
            return Optional.ofNullable(clazz.cast(testSpecArn()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunTestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleRunTest> {
        /**
         * <p>
         * The test's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The test's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The test's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The test's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * The ARN of the uploaded test that will be run.
         * </p>
         * 
         * @param testPackageArn
         *        The ARN of the uploaded test that will be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testPackageArn(String testPackageArn);

        /**
         * <p>
         * The ARN of the YAML-formatted test specification.
         * </p>
         * 
         * @param testSpecArn
         *        The ARN of the YAML-formatted test specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSpecArn(String testSpecArn);

        /**
         * <p>
         * The test's filter.
         * </p>
         * 
         * @param filter
         *        The test's filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        /**
         * <p>
         * The test's parameters, such as the following test framework parameters and fixture settings:
         * </p>
         * <p>
         * For Calabash tests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * profile: A cucumber profile, for example, "my_profile_name".
         * </p>
         * </li>
         * <li>
         * <p>
         * tags: You can limit execution to features or scenarios that have (or don't have) certain tags, for example,
         * "@smoke" or "@smoke,~@wip".
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Appium tests (all types):
         * </p>
         * <ul>
         * <li>
         * <p>
         * appium_version: The Appium version. Currently supported values are "1.4.16", "1.6.3", "latest", and
         * "default".
         * </p>
         * <ul>
         * <li>
         * <p>
         * “latest” will run the latest Appium version supported by Device Farm (1.6.3).
         * </p>
         * </li>
         * <li>
         * <p>
         * For “default”, Device Farm will choose a compatible version of Appium for the device. The current behavior is
         * to run 1.4.16 on Android devices and iOS 9 and earlier, 1.6.3 for iOS 10 and later.
         * </p>
         * </li>
         * <li>
         * <p>
         * This behavior is subject to change.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * For Fuzz tests (Android only):
         * </p>
         * <ul>
         * <li>
         * <p>
         * event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
         * </p>
         * </li>
         * <li>
         * <p>
         * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
         * </p>
         * </li>
         * <li>
         * <p>
         * seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures
         * identical event sequences.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Explorer tests:
         * </p>
         * <ul>
         * <li>
         * <p>
         * username: A username to use if the Explorer encounters a login form. If not supplied, no username will be
         * inserted.
         * </p>
         * </li>
         * <li>
         * <p>
         * password: A password to use if the Explorer encounters a login form. If not supplied, no password will be
         * inserted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For Instrumentation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * filter: A test filter string. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running a single test case: "com.android.abc.Test1"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a single test: "com.android.abc.Test1#smoke"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * For XCTest and XCTestUI:
         * </p>
         * <ul>
         * <li>
         * <p>
         * filter: A test filter string. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running a single test class: "LoginTests"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a multiple test classes: "LoginTests,SmokeTests"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a single test: "LoginTests/testValid"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * For UIAutomator:
         * </p>
         * <ul>
         * <li>
         * <p>
         * filter: A test filter string. Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running a single test case: "com.android.abc.Test1"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running a single test: "com.android.abc.Test1#smoke"
         * </p>
         * </li>
         * <li>
         * <p>
         * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param parameters
         *        The test's parameters, such as the following test framework parameters and fixture settings:</p>
         *        <p>
         *        For Calabash tests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        profile: A cucumber profile, for example, "my_profile_name".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        tags: You can limit execution to features or scenarios that have (or don't have) certain tags, for
         *        example, "@smoke" or "@smoke,~@wip".
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Appium tests (all types):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        appium_version: The Appium version. Currently supported values are "1.4.16", "1.6.3", "latest", and
         *        "default".
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        “latest” will run the latest Appium version supported by Device Farm (1.6.3).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For “default”, Device Farm will choose a compatible version of Appium for the device. The current
         *        behavior is to run 1.4.16 on Android devices and iOS 9 and earlier, 1.6.3 for iOS 10 and later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This behavior is subject to change.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        For Fuzz tests (Android only):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures
         *        identical event sequences.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Explorer tests:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        username: A username to use if the Explorer encounters a login form. If not supplied, no username will
         *        be inserted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        password: A password to use if the Explorer encounters a login form. If not supplied, no password will
         *        be inserted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For Instrumentation:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        filter: A test filter string. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running a single test case: "com.android.abc.Test1"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a single test: "com.android.abc.Test1#smoke"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        For XCTest and XCTestUI:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        filter: A test filter string. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running a single test class: "LoginTests"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a multiple test classes: "LoginTests,SmokeTests"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a single test: "LoginTests/testValid"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        For UIAutomator:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        filter: A test filter string. Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running a single test case: "com.android.abc.Test1"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running a single test: "com.android.abc.Test1#smoke"
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String testPackageArn;

        private String testSpecArn;

        private String filter;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunTest model) {
            type(model.type);
            testPackageArn(model.testPackageArn);
            testSpecArn(model.testSpecArn);
            filter(model.filter);
            parameters(model.parameters);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTestPackageArn() {
            return testPackageArn;
        }

        @Override
        public final Builder testPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
            return this;
        }

        public final void setTestPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
        }

        public final String getTestSpecArn() {
            return testSpecArn;
        }

        @Override
        public final Builder testSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
            return this;
        }

        public final void setTestSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
        }

        public final String getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
        }

        @Override
        public ScheduleRunTest build() {
            return new ScheduleRunTest(this);
        }
    }
}
