/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CustomerArtifactPaths} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CustomerArtifactPathsMarshaller {
    private static final MarshallingInfo<List> IOSPATHS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iosPaths").isBinary(false).build();

    private static final MarshallingInfo<List> ANDROIDPATHS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("androidPaths").isBinary(false).build();

    private static final MarshallingInfo<List> DEVICEHOSTPATHS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceHostPaths").isBinary(false).build();

    private static final CustomerArtifactPathsMarshaller INSTANCE = new CustomerArtifactPathsMarshaller();

    private CustomerArtifactPathsMarshaller() {
    }

    public static CustomerArtifactPathsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CustomerArtifactPaths customerArtifactPaths, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(customerArtifactPaths, "customerArtifactPaths");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(customerArtifactPaths.iosPaths(), IOSPATHS_BINDING);
            protocolMarshaller.marshall(customerArtifactPaths.androidPaths(), ANDROIDPATHS_BINDING);
            protocolMarshaller.marshall(customerArtifactPaths.deviceHostPaths(), DEVICEHOSTPATHS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
