/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Device JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeviceUnmarshaller implements Unmarshaller<Device, JsonUnmarshallerContext> {

    public Device unmarshall(JsonUnmarshallerContext context) throws Exception {
        Device.Builder deviceBuilder = Device.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("manufacturer", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.manufacturer(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("model", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.model(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("modelId", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.modelId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("formFactor", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.formFactor(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("platform", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.platform(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("os", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.os(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("cpu", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.cpu(CPUUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resolution", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.resolution(ResolutionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("heapSize", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.heapSize(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("memory", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.memory(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("image", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.image(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("carrier", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.carrier(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("radio", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.radio(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("remoteAccessEnabled", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.remoteAccessEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("remoteDebugEnabled", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.remoteDebugEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("fleetType", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.fleetType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("fleetName", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.fleetName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instances", targetDepth)) {
                    context.nextToken();
                    deviceBuilder.instances(new ListUnmarshaller<DeviceInstance>(DeviceInstanceUnmarshaller.getInstance())
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deviceBuilder.build();
    }

    private static final DeviceUnmarshaller INSTANCE = new DeviceUnmarshaller();

    public static DeviceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
