/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.InstanceProfile;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstanceProfile} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceProfileMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<Boolean> PACKAGECLEANUP_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packageCleanup").isBinary(false).build();

    private static final MarshallingInfo<List> EXCLUDEAPPPACKAGESFROMCLEANUP_BINDING = MarshallingInfo
            .builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("excludeAppPackagesFromCleanup").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REBOOTAFTERUSE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rebootAfterUse").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final InstanceProfileMarshaller INSTANCE = new InstanceProfileMarshaller();

    private InstanceProfileMarshaller() {
    }

    public static InstanceProfileMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstanceProfile instanceProfile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instanceProfile, "instanceProfile");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instanceProfile.arn(), ARN_BINDING);
            protocolMarshaller.marshall(instanceProfile.packageCleanup(), PACKAGECLEANUP_BINDING);
            protocolMarshaller.marshall(instanceProfile.excludeAppPackagesFromCleanup(), EXCLUDEAPPPACKAGESFROMCLEANUP_BINDING);
            protocolMarshaller.marshall(instanceProfile.rebootAfterUse(), REBOOTAFTERUSE_BINDING);
            protocolMarshaller.marshall(instanceProfile.name(), NAME_BINDING);
            protocolMarshaller.marshall(instanceProfile.description(), DESCRIPTION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
