/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RemoteAccessSession JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RemoteAccessSessionUnmarshaller implements Unmarshaller<RemoteAccessSession, JsonUnmarshallerContext> {

    public RemoteAccessSession unmarshall(JsonUnmarshallerContext context) throws Exception {
        RemoteAccessSession.Builder remoteAccessSessionBuilder = RemoteAccessSession.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("created", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.created(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("result", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.result(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.message(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("started", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.started(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("stopped", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.stopped(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("device", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.device(DeviceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("instanceArn", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.instanceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("remoteDebugEnabled", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.remoteDebugEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("remoteRecordEnabled", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.remoteRecordEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("remoteRecordAppArn", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.remoteRecordAppArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("hostAddress", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.hostAddress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("clientId", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.clientId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("billingMethod", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.billingMethod(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deviceMinutes", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.deviceMinutes(DeviceMinutesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("endpoint", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.endpoint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("deviceUdid", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.deviceUdid(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("interactionMode", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.interactionMode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("skipAppResign", targetDepth)) {
                    context.nextToken();
                    remoteAccessSessionBuilder.skipAppResign(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return remoteAccessSessionBuilder.build();
    }

    private static final RemoteAccessSessionUnmarshaller INSTANCE = new RemoteAccessSessionUnmarshaller();

    public static RemoteAccessSessionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
