/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Run;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Run} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RunMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();

    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("started").isBinary(false).build();

    private static final MarshallingInfo<Instant> STOPPED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> COUNTERS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("counters").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();

    private static final MarshallingInfo<Integer> TOTALJOBS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalJobs").isBinary(false).build();

    private static final MarshallingInfo<Integer> COMPLETEDJOBS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedJobs").isBinary(false).build();

    private static final MarshallingInfo<String> BILLINGMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingMethod").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DEVICEMINUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceMinutes")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NETWORKPROFILE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("networkProfile").isBinary(false).build();

    private static final MarshallingInfo<String> PARSINGRESULTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parsingResultUrl").isBinary(false).build();

    private static final MarshallingInfo<String> RESULTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resultCode").isBinary(false).build();

    private static final MarshallingInfo<Integer> SEED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("seed").isBinary(false).build();

    private static final MarshallingInfo<String> APPUPLOAD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appUpload").isBinary(false).build();

    private static final MarshallingInfo<Integer> EVENTCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> JOBTIMEOUTMINUTES_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobTimeoutMinutes").isBinary(false).build();

    private static final MarshallingInfo<String> DEVICEPOOLARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("devicePoolArn").isBinary(false).build();

    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("locale").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RADIOS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("radios").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CUSTOMERARTIFACTPATHS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("customerArtifactPaths").isBinary(false).build();

    private static final MarshallingInfo<String> WEBURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("webUrl").isBinary(false).build();

    private static final MarshallingInfo<Boolean> SKIPAPPRESIGN_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("skipAppResign").isBinary(false).build();

    private static final MarshallingInfo<String> TESTSPECARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("testSpecArn").isBinary(false).build();

    private static final RunMarshaller INSTANCE = new RunMarshaller();

    private RunMarshaller() {
    }

    public static RunMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Run run, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(run, "run");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(run.arn(), ARN_BINDING);
            protocolMarshaller.marshall(run.name(), NAME_BINDING);
            protocolMarshaller.marshall(run.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(run.platformAsString(), PLATFORM_BINDING);
            protocolMarshaller.marshall(run.created(), CREATED_BINDING);
            protocolMarshaller.marshall(run.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(run.resultAsString(), RESULT_BINDING);
            protocolMarshaller.marshall(run.started(), STARTED_BINDING);
            protocolMarshaller.marshall(run.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall(run.counters(), COUNTERS_BINDING);
            protocolMarshaller.marshall(run.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(run.totalJobs(), TOTALJOBS_BINDING);
            protocolMarshaller.marshall(run.completedJobs(), COMPLETEDJOBS_BINDING);
            protocolMarshaller.marshall(run.billingMethodAsString(), BILLINGMETHOD_BINDING);
            protocolMarshaller.marshall(run.deviceMinutes(), DEVICEMINUTES_BINDING);
            protocolMarshaller.marshall(run.networkProfile(), NETWORKPROFILE_BINDING);
            protocolMarshaller.marshall(run.parsingResultUrl(), PARSINGRESULTURL_BINDING);
            protocolMarshaller.marshall(run.resultCodeAsString(), RESULTCODE_BINDING);
            protocolMarshaller.marshall(run.seed(), SEED_BINDING);
            protocolMarshaller.marshall(run.appUpload(), APPUPLOAD_BINDING);
            protocolMarshaller.marshall(run.eventCount(), EVENTCOUNT_BINDING);
            protocolMarshaller.marshall(run.jobTimeoutMinutes(), JOBTIMEOUTMINUTES_BINDING);
            protocolMarshaller.marshall(run.devicePoolArn(), DEVICEPOOLARN_BINDING);
            protocolMarshaller.marshall(run.locale(), LOCALE_BINDING);
            protocolMarshaller.marshall(run.radios(), RADIOS_BINDING);
            protocolMarshaller.marshall(run.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(run.customerArtifactPaths(), CUSTOMERARTIFACTPATHS_BINDING);
            protocolMarshaller.marshall(run.webUrl(), WEBURL_BINDING);
            protocolMarshaller.marshall(run.skipAppResign(), SKIPAPPRESIGN_BINDING);
            protocolMarshaller.marshall(run.testSpecArn(), TESTSPECARN_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
