/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ScheduleRunRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ScheduleRunRequestModelMarshaller {
    private static final MarshallingInfo<String> PROJECTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectArn").isBinary(false).build();

    private static final MarshallingInfo<String> APPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appArn").isBinary(false).build();

    private static final MarshallingInfo<String> DEVICEPOOLARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("devicePoolArn").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TEST_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("test").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> EXECUTIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("executionConfiguration").isBinary(false).build();

    private static final ScheduleRunRequestModelMarshaller INSTANCE = new ScheduleRunRequestModelMarshaller();

    private ScheduleRunRequestModelMarshaller() {
    }

    public static ScheduleRunRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ScheduleRunRequest scheduleRunRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(scheduleRunRequest, "scheduleRunRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(scheduleRunRequest.projectArn(), PROJECTARN_BINDING);
            protocolMarshaller.marshall(scheduleRunRequest.appArn(), APPARN_BINDING);
            protocolMarshaller.marshall(scheduleRunRequest.devicePoolArn(), DEVICEPOOLARN_BINDING);
            protocolMarshaller.marshall(scheduleRunRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(scheduleRunRequest.test(), TEST_BINDING);
            protocolMarshaller.marshall(scheduleRunRequest.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(scheduleRunRequest.executionConfiguration(), EXECUTIONCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
