/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateVpceConfigurationRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateVpceConfigurationRequestModelMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> VPCECONFIGURATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpceConfigurationName").isBinary(false).build();

    private static final MarshallingInfo<String> VPCESERVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpceServiceName").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICEDNSNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceDnsName").isBinary(false).build();

    private static final MarshallingInfo<String> VPCECONFIGURATIONDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("vpceConfigurationDescription").isBinary(false).build();

    private static final UpdateVpceConfigurationRequestModelMarshaller INSTANCE = new UpdateVpceConfigurationRequestModelMarshaller();

    private UpdateVpceConfigurationRequestModelMarshaller() {
    }

    public static UpdateVpceConfigurationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateVpceConfigurationRequest updateVpceConfigurationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateVpceConfigurationRequest, "updateVpceConfigurationRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateVpceConfigurationRequest.arn(), ARN_BINDING);
            protocolMarshaller.marshall(updateVpceConfigurationRequest.vpceConfigurationName(), VPCECONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall(updateVpceConfigurationRequest.vpceServiceName(), VPCESERVICENAME_BINDING);
            protocolMarshaller.marshall(updateVpceConfigurationRequest.serviceDnsName(), SERVICEDNSNAME_BINDING);
            protocolMarshaller.marshall(updateVpceConfigurationRequest.vpceConfigurationDescription(),
                    VPCECONFIGURATIONDESCRIPTION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
