/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * VPCEConfiguration JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VPCEConfigurationUnmarshaller implements Unmarshaller<VPCEConfiguration, JsonUnmarshallerContext> {

    public VPCEConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        VPCEConfiguration.Builder vpceConfigurationBuilder = VPCEConfiguration.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    vpceConfigurationBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vpceConfigurationName", targetDepth)) {
                    context.nextToken();
                    vpceConfigurationBuilder.vpceConfigurationName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vpceServiceName", targetDepth)) {
                    context.nextToken();
                    vpceConfigurationBuilder.vpceServiceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("serviceDnsName", targetDepth)) {
                    context.nextToken();
                    vpceConfigurationBuilder.serviceDnsName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vpceConfigurationDescription", targetDepth)) {
                    context.nextToken();
                    vpceConfigurationBuilder.vpceConfigurationDescription(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return vpceConfigurationBuilder.build();
    }

    private static final VPCEConfigurationUnmarshaller INSTANCE = new VPCEConfigurationUnmarshaller();

    public static VPCEConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
