/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ExecutionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ExecutionConfiguration> {
    private final Integer jobTimeoutMinutes;
    private final Boolean accountsCleanup;
    private final Boolean appPackagesCleanup;
    private final Boolean videoCapture;
    private final Boolean skipAppResign;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.accountsCleanup = builder.accountsCleanup;
        this.appPackagesCleanup = builder.appPackagesCleanup;
        this.videoCapture = builder.videoCapture;
        this.skipAppResign = builder.skipAppResign;
    }

    public Integer jobTimeoutMinutes() {
        return this.jobTimeoutMinutes;
    }

    public Boolean accountsCleanup() {
        return this.accountsCleanup;
    }

    public Boolean appPackagesCleanup() {
        return this.appPackagesCleanup;
    }

    public Boolean videoCapture() {
        return this.videoCapture;
    }

    public Boolean skipAppResign() {
        return this.skipAppResign;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountsCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.appPackagesCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoCapture());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration)obj;
        return Objects.equals(this.jobTimeoutMinutes(), other.jobTimeoutMinutes()) && Objects.equals(this.accountsCleanup(), other.accountsCleanup()) && Objects.equals(this.appPackagesCleanup(), other.appPackagesCleanup()) && Objects.equals(this.videoCapture(), other.videoCapture()) && Objects.equals(this.skipAppResign(), other.skipAppResign());
    }

    public String toString() {
        return ToString.builder((String)"ExecutionConfiguration").add("JobTimeoutMinutes", (Object)this.jobTimeoutMinutes()).add("AccountsCleanup", (Object)this.accountsCleanup()).add("AppPackagesCleanup", (Object)this.appPackagesCleanup()).add("VideoCapture", (Object)this.videoCapture()).add("SkipAppResign", (Object)this.skipAppResign()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.jobTimeoutMinutes()));
            }
            case "accountsCleanup": {
                return Optional.ofNullable(clazz.cast(this.accountsCleanup()));
            }
            case "appPackagesCleanup": {
                return Optional.ofNullable(clazz.cast(this.appPackagesCleanup()));
            }
            case "videoCapture": {
                return Optional.ofNullable(clazz.cast(this.videoCapture()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer jobTimeoutMinutes;
        private Boolean accountsCleanup;
        private Boolean appPackagesCleanup;
        private Boolean videoCapture;
        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            this.jobTimeoutMinutes(model.jobTimeoutMinutes);
            this.accountsCleanup(model.accountsCleanup);
            this.appPackagesCleanup(model.appPackagesCleanup);
            this.videoCapture(model.videoCapture);
            this.skipAppResign(model.skipAppResign);
        }

        public final Integer getJobTimeoutMinutes() {
            return this.jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        public final Boolean getAccountsCleanup() {
            return this.accountsCleanup;
        }

        @Override
        public final Builder accountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
            return this;
        }

        public final void setAccountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
        }

        public final Boolean getAppPackagesCleanup() {
            return this.appPackagesCleanup;
        }

        @Override
        public final Builder appPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
            return this;
        }

        public final void setAppPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
        }

        public final Boolean getVideoCapture() {
            return this.videoCapture;
        }

        @Override
        public final Builder videoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        public final void setVideoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExecutionConfiguration> {
        public Builder jobTimeoutMinutes(Integer var1);

        public Builder accountsCleanup(Boolean var1);

        public Builder appPackagesCleanup(Boolean var1);

        public Builder videoCapture(Boolean var1);

        public Builder skipAppResign(Boolean var1);
    }
}

