/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.DeviceInstance;
import software.amazon.awssdk.services.devicefarm.model.DeviceInstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceInstancesResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListDeviceInstancesResponse> {
    private final List<DeviceInstance> deviceInstances;
    private final String nextToken;

    private ListDeviceInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceInstances = builder.deviceInstances;
        this.nextToken = builder.nextToken;
    }

    public List<DeviceInstance> deviceInstances() {
        return this.deviceInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceInstancesResponse)) {
            return false;
        }
        ListDeviceInstancesResponse other = (ListDeviceInstancesResponse)((Object)obj);
        return Objects.equals(this.deviceInstances(), other.deviceInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeviceInstancesResponse").add("DeviceInstances", this.deviceInstances()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceInstances": {
                return Optional.ofNullable(clazz.cast(this.deviceInstances()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<DeviceInstance> deviceInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceInstancesResponse model) {
            super(model);
            this.deviceInstances(model.deviceInstances);
            this.nextToken(model.nextToken);
        }

        public final Collection<DeviceInstance.Builder> getDeviceInstances() {
            return this.deviceInstances != null ? (Collection)this.deviceInstances.stream().map(DeviceInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceInstances(Collection<DeviceInstance> deviceInstances) {
            this.deviceInstances = DeviceInstancesCopier.copy(deviceInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceInstances(DeviceInstance ... deviceInstances) {
            this.deviceInstances(Arrays.asList(deviceInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceInstances(Consumer<DeviceInstance.Builder> ... deviceInstances) {
            this.deviceInstances(Stream.of(deviceInstances).map(c -> (DeviceInstance)((DeviceInstance.Builder)DeviceInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceInstances(Collection<DeviceInstance.BuilderImpl> deviceInstances) {
            this.deviceInstances = DeviceInstancesCopier.copyFromBuilder(deviceInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeviceInstancesResponse build() {
            return new ListDeviceInstancesResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListDeviceInstancesResponse> {
        public Builder deviceInstances(Collection<DeviceInstance> var1);

        public Builder deviceInstances(DeviceInstance ... var1);

        public Builder deviceInstances(Consumer<DeviceInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

