/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Upload;
import software.amazon.awssdk.services.devicefarm.model.UploadsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUploadsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListUploadsResponse> {
    private final List<Upload> uploads;
    private final String nextToken;

    private ListUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.uploads = builder.uploads;
        this.nextToken = builder.nextToken;
    }

    public List<Upload> uploads() {
        return this.uploads;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uploads());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUploadsResponse)) {
            return false;
        }
        ListUploadsResponse other = (ListUploadsResponse)((Object)obj);
        return Objects.equals(this.uploads(), other.uploads()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListUploadsResponse").add("Uploads", this.uploads()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uploads": {
                return Optional.ofNullable(clazz.cast(this.uploads()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Upload> uploads = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUploadsResponse model) {
            super(model);
            this.uploads(model.uploads);
            this.nextToken(model.nextToken);
        }

        public final Collection<Upload.Builder> getUploads() {
            return this.uploads != null ? (Collection)this.uploads.stream().map(Upload::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploads(Collection<Upload> uploads) {
            this.uploads = UploadsCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Upload ... uploads) {
            this.uploads(Arrays.asList(uploads));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Consumer<Upload.Builder> ... uploads) {
            this.uploads(Stream.of(uploads).map(c -> (Upload)((Upload.Builder)Upload.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUploads(Collection<Upload.BuilderImpl> uploads) {
            this.uploads = UploadsCopier.copyFromBuilder(uploads);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUploadsResponse build() {
            return new ListUploadsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListUploadsResponse> {
        public Builder uploads(Collection<Upload> var1);

        public Builder uploads(Upload ... var1);

        public Builder uploads(Consumer<Upload.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

