/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceMinutesMarshaller {
    private static final MarshallingInfo<Double> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("total").isBinary(false).build();
    private static final MarshallingInfo<Double> METERED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metered").isBinary(false).build();
    private static final MarshallingInfo<Double> UNMETERED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unmetered").isBinary(false).build();
    private static final DeviceMinutesMarshaller INSTANCE = new DeviceMinutesMarshaller();

    private DeviceMinutesMarshaller() {
    }

    public static DeviceMinutesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceMinutes deviceMinutes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceMinutes, (String)"deviceMinutes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deviceMinutes.total(), TOTAL_BINDING);
            protocolMarshaller.marshall((Object)deviceMinutes.metered(), METERED_BINDING);
            protocolMarshaller.marshall((Object)deviceMinutes.unmetered(), UNMETERED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

