/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.RecurringCharge;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecurringChargeMarshaller {
    private static final MarshallingInfo<StructuredPojo> COST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cost").isBinary(false).build();
    private static final MarshallingInfo<String> FREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").isBinary(false).build();
    private static final RecurringChargeMarshaller INSTANCE = new RecurringChargeMarshaller();

    private RecurringChargeMarshaller() {
    }

    public static RecurringChargeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecurringCharge recurringCharge, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recurringCharge, (String)"recurringCharge");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recurringCharge.cost(), COST_BINDING);
            protocolMarshaller.marshall((Object)recurringCharge.frequencyAsString(), FREQUENCY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

