/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Rule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RuleMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attribute").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operator").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final RuleMarshaller INSTANCE = new RuleMarshaller();

    private RuleMarshaller() {
    }

    public static RuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Rule rule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rule, (String)"rule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rule.attributeAsString(), ATTRIBUTE_BINDING);
            protocolMarshaller.marshall((Object)rule.operatorAsString(), OPERATOR_BINDING);
            protocolMarshaller.marshall((Object)rule.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

