/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScheduleRunRequestModelMarshaller {
    private static final MarshallingInfo<String> PROJECTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("projectArn").isBinary(false).build();
    private static final MarshallingInfo<String> APPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEPOOLARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("devicePoolArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("test").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionConfiguration").isBinary(false).build();
    private static final ScheduleRunRequestModelMarshaller INSTANCE = new ScheduleRunRequestModelMarshaller();

    private ScheduleRunRequestModelMarshaller() {
    }

    public static ScheduleRunRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScheduleRunRequest scheduleRunRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)scheduleRunRequest), (String)"scheduleRunRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scheduleRunRequest.projectArn(), PROJECTARN_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunRequest.appArn(), APPARN_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunRequest.devicePoolArn(), DEVICEPOOLARN_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunRequest.test(), TEST_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunRequest.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)scheduleRunRequest.executionConfiguration(), EXECUTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

