/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.AccountSettingsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for account-level settings within AWS Device Farm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AccountSettings implements StructuredPojo, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private final String awsAccountNumber;

    private final Map<String, Integer> unmeteredDevices;

    private final Map<String, Integer> unmeteredRemoteAccessDevices;

    private final Integer maxJobTimeoutMinutes;

    private final TrialMinutes trialMinutes;

    private final Map<String, Integer> maxSlots;

    private final Integer defaultJobTimeoutMinutes;

    private AccountSettings(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.unmeteredDevices = builder.unmeteredDevices;
        this.unmeteredRemoteAccessDevices = builder.unmeteredRemoteAccessDevices;
        this.maxJobTimeoutMinutes = builder.maxJobTimeoutMinutes;
        this.trialMinutes = builder.trialMinutes;
        this.maxSlots = builder.maxSlots;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * The AWS account number specified in the <code>AccountSettings</code> container.
     * </p>
     * 
     * @return The AWS account number specified in the <code>AccountSettings</code> container.
     */
    public String awsAccountNumber() {
        return awsAccountNumber;
    }

    /**
     * <p>
     * Returns the unmetered devices you have purchased or want to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the unmetered devices you have purchased or want to purchase.
     */
    public Map<String, Integer> unmeteredDevices() {
        return unmeteredDevices;
    }

    /**
     * <p>
     * Returns the unmetered remote access devices you have purchased or want to purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the unmetered remote access devices you have purchased or want to purchase.
     */
    public Map<String, Integer> unmeteredRemoteAccessDevices() {
        return unmeteredRemoteAccessDevices;
    }

    /**
     * <p>
     * The maximum number of minutes a test run will execute before it times out.
     * </p>
     * 
     * @return The maximum number of minutes a test run will execute before it times out.
     */
    public Integer maxJobTimeoutMinutes() {
        return maxJobTimeoutMinutes;
    }

    /**
     * <p>
     * Information about an AWS account's usage of free trial device minutes.
     * </p>
     * 
     * @return Information about an AWS account's usage of free trial device minutes.
     */
    public TrialMinutes trialMinutes() {
        return trialMinutes;
    }

    /**
     * <p>
     * The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
     * <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs returned by
     * the <code>ListOfferings</code> command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
     *         <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs
     *         returned by the <code>ListOfferings</code> command.
     */
    public Map<String, Integer> maxSlots() {
        return maxSlots;
    }

    /**
     * <p>
     * The default number of minutes (at the account level) a test run will execute before it times out. Default value
     * is 60 minutes.
     * </p>
     * 
     * @return The default number of minutes (at the account level) a test run will execute before it times out. Default
     *         value is 60 minutes.
     */
    public Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((awsAccountNumber() == null) ? 0 : awsAccountNumber().hashCode());
        hashCode = 31 * hashCode + ((unmeteredDevices() == null) ? 0 : unmeteredDevices().hashCode());
        hashCode = 31 * hashCode + ((unmeteredRemoteAccessDevices() == null) ? 0 : unmeteredRemoteAccessDevices().hashCode());
        hashCode = 31 * hashCode + ((maxJobTimeoutMinutes() == null) ? 0 : maxJobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + ((trialMinutes() == null) ? 0 : trialMinutes().hashCode());
        hashCode = 31 * hashCode + ((maxSlots() == null) ? 0 : maxSlots().hashCode());
        hashCode = 31 * hashCode + ((defaultJobTimeoutMinutes() == null) ? 0 : defaultJobTimeoutMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        if (other.awsAccountNumber() == null ^ this.awsAccountNumber() == null) {
            return false;
        }
        if (other.awsAccountNumber() != null && !other.awsAccountNumber().equals(this.awsAccountNumber())) {
            return false;
        }
        if (other.unmeteredDevices() == null ^ this.unmeteredDevices() == null) {
            return false;
        }
        if (other.unmeteredDevices() != null && !other.unmeteredDevices().equals(this.unmeteredDevices())) {
            return false;
        }
        if (other.unmeteredRemoteAccessDevices() == null ^ this.unmeteredRemoteAccessDevices() == null) {
            return false;
        }
        if (other.unmeteredRemoteAccessDevices() != null
                && !other.unmeteredRemoteAccessDevices().equals(this.unmeteredRemoteAccessDevices())) {
            return false;
        }
        if (other.maxJobTimeoutMinutes() == null ^ this.maxJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.maxJobTimeoutMinutes() != null && !other.maxJobTimeoutMinutes().equals(this.maxJobTimeoutMinutes())) {
            return false;
        }
        if (other.trialMinutes() == null ^ this.trialMinutes() == null) {
            return false;
        }
        if (other.trialMinutes() != null && !other.trialMinutes().equals(this.trialMinutes())) {
            return false;
        }
        if (other.maxSlots() == null ^ this.maxSlots() == null) {
            return false;
        }
        if (other.maxSlots() != null && !other.maxSlots().equals(this.maxSlots())) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() == null ^ this.defaultJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() != null && !other.defaultJobTimeoutMinutes().equals(this.defaultJobTimeoutMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (awsAccountNumber() != null) {
            sb.append("AwsAccountNumber: ").append(awsAccountNumber()).append(",");
        }
        if (unmeteredDevices() != null) {
            sb.append("UnmeteredDevices: ").append(unmeteredDevices()).append(",");
        }
        if (unmeteredRemoteAccessDevices() != null) {
            sb.append("UnmeteredRemoteAccessDevices: ").append(unmeteredRemoteAccessDevices()).append(",");
        }
        if (maxJobTimeoutMinutes() != null) {
            sb.append("MaxJobTimeoutMinutes: ").append(maxJobTimeoutMinutes()).append(",");
        }
        if (trialMinutes() != null) {
            sb.append("TrialMinutes: ").append(trialMinutes()).append(",");
        }
        if (maxSlots() != null) {
            sb.append("MaxSlots: ").append(maxSlots()).append(",");
        }
        if (defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(defaultJobTimeoutMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * The AWS account number specified in the <code>AccountSettings</code> container.
         * </p>
         * 
         * @param awsAccountNumber
         *        The AWS account number specified in the <code>AccountSettings</code> container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountNumber(String awsAccountNumber);

        /**
         * <p>
         * Returns the unmetered devices you have purchased or want to purchase.
         * </p>
         * 
         * @param unmeteredDevices
         *        Returns the unmetered devices you have purchased or want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmeteredDevices(Map<String, Integer> unmeteredDevices);

        /**
         * <p>
         * Returns the unmetered remote access devices you have purchased or want to purchase.
         * </p>
         * 
         * @param unmeteredRemoteAccessDevices
         *        Returns the unmetered remote access devices you have purchased or want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices);

        /**
         * <p>
         * The maximum number of minutes a test run will execute before it times out.
         * </p>
         * 
         * @param maxJobTimeoutMinutes
         *        The maximum number of minutes a test run will execute before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes);

        /**
         * <p>
         * Information about an AWS account's usage of free trial device minutes.
         * </p>
         * 
         * @param trialMinutes
         *        Information about an AWS account's usage of free trial device minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialMinutes(TrialMinutes trialMinutes);

        /**
         * <p>
         * The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
         * <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs returned
         * by the <code>ListOfferings</code> command.
         * </p>
         * 
         * @param maxSlots
         *        The maximum number of device slots that the AWS account can purchase. Each maximum is expressed as an
         *        <code>offering-id:number</code> pair, where the <code>offering-id</code> represents one of the IDs
         *        returned by the <code>ListOfferings</code> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlots(Map<String, Integer> maxSlots);

        /**
         * <p>
         * The default number of minutes (at the account level) a test run will execute before it times out. Default
         * value is 60 minutes.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        The default number of minutes (at the account level) a test run will execute before it times out.
         *        Default value is 60 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);
    }

    private static final class BuilderImpl implements Builder {
        private String awsAccountNumber;

        private Map<String, Integer> unmeteredDevices;

        private Map<String, Integer> unmeteredRemoteAccessDevices;

        private Integer maxJobTimeoutMinutes;

        private TrialMinutes trialMinutes;

        private Map<String, Integer> maxSlots;

        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            setAwsAccountNumber(model.awsAccountNumber);
            setUnmeteredDevices(model.unmeteredDevices);
            setUnmeteredRemoteAccessDevices(model.unmeteredRemoteAccessDevices);
            setMaxJobTimeoutMinutes(model.maxJobTimeoutMinutes);
            setTrialMinutes(model.trialMinutes);
            setMaxSlots(model.maxSlots);
            setDefaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getAwsAccountNumber() {
            return awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        public final Map<String, Integer> getUnmeteredDevices() {
            return unmeteredDevices;
        }

        @Override
        public final Builder unmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
            return this;
        }

        public final void setUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
        }

        public final Map<String, Integer> getUnmeteredRemoteAccessDevices() {
            return unmeteredRemoteAccessDevices;
        }

        @Override
        public final Builder unmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
            return this;
        }

        public final void setUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
        }

        public final Integer getMaxJobTimeoutMinutes() {
            return maxJobTimeoutMinutes;
        }

        @Override
        public final Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
            return this;
        }

        public final void setMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
        }

        public final TrialMinutes getTrialMinutes() {
            return trialMinutes;
        }

        @Override
        public final Builder trialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
            return this;
        }

        public final void setTrialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
        }

        public final Map<String, Integer> getMaxSlots() {
            return maxSlots;
        }

        @Override
        public final Builder maxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
            return this;
        }

        public final void setMaxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }
    }
}
