/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the create device pool operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDevicePoolRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDevicePoolRequest.Builder, CreateDevicePoolRequest> {
    private final String projectArn;

    private final String name;

    private final String description;

    private final List<Rule> rules;

    private CreateDevicePoolRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The ARN of the project for the device pool.
     * </p>
     * 
     * @return The ARN of the project for the device pool.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The device pool's name.
     * </p>
     * 
     * @return The device pool's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The device pool's description.
     * </p>
     * 
     * @return The device pool's description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The device pool's rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The device pool's rules.
     */
    public List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((projectArn() == null) ? 0 : projectArn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevicePoolRequest)) {
            return false;
        }
        CreateDevicePoolRequest other = (CreateDevicePoolRequest) obj;
        if (other.projectArn() == null ^ this.projectArn() == null) {
            return false;
        }
        if (other.projectArn() != null && !other.projectArn().equals(this.projectArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (projectArn() != null) {
            sb.append("ProjectArn: ").append(projectArn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDevicePoolRequest> {
        /**
         * <p>
         * The ARN of the project for the device pool.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the project for the device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The device pool's name.
         * </p>
         * 
         * @param name
         *        The device pool's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device pool's description.
         * </p>
         * 
         * @param description
         *        The device pool's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The device pool's rules.
         * </p>
         * 
         * @param rules
         *        The device pool's rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The device pool's rules.
         * </p>
         * 
         * @param rules
         *        The device pool's rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);
    }

    private static final class BuilderImpl implements Builder {
        private String projectArn;

        private String name;

        private String description;

        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevicePoolRequest model) {
            setProjectArn(model.projectArn);
            setName(model.name);
            setDescription(model.description);
            setRules(model.rules);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Rule> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(Rule... rules) {
            rules(Arrays.asList(rules));
        }

        @Override
        public CreateDevicePoolRequest build() {
            return new CreateDevicePoolRequest(this);
        }
    }
}
