/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device type that an app is tested against.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Device implements StructuredPojo, ToCopyableBuilder<Device.Builder, Device> {
    private final String arn;

    private final String name;

    private final String manufacturer;

    private final String model;

    private final String formFactor;

    private final String platform;

    private final String os;

    private final CPU cpu;

    private final Resolution resolution;

    private final Long heapSize;

    private final Long memory;

    private final String image;

    private final String carrier;

    private final String radio;

    private final Boolean remoteAccessEnabled;

    private final String fleetType;

    private final String fleetName;

    private Device(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.formFactor = builder.formFactor;
        this.platform = builder.platform;
        this.os = builder.os;
        this.cpu = builder.cpu;
        this.resolution = builder.resolution;
        this.heapSize = builder.heapSize;
        this.memory = builder.memory;
        this.image = builder.image;
        this.carrier = builder.carrier;
        this.radio = builder.radio;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
        this.fleetType = builder.fleetType;
        this.fleetName = builder.fleetName;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The device's display name.
     * </p>
     * 
     * @return The device's display name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The device's manufacturer name.
     * </p>
     * 
     * @return The device's manufacturer name.
     */
    public String manufacturer() {
        return manufacturer;
    }

    /**
     * <p>
     * The device's model name.
     * </p>
     * 
     * @return The device's model name.
     */
    public String model() {
        return model;
    }

    /**
     * <p>
     * The device's form factor.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE: The phone form factor.
     * </p>
     * </li>
     * <li>
     * <p>
     * TABLET: The tablet form factor.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The device's form factor.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE: The phone form factor.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TABLET: The tablet form factor.
     *         </p>
     *         </li>
     * @see DeviceFormFactor
     */
    public String formFactor() {
        return formFactor;
    }

    /**
     * <p>
     * The device's platform.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID: The Android platform.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS: The iOS platform.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The device's platform.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID: The Android platform.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS: The iOS platform.
     *         </p>
     *         </li>
     * @see DevicePlatform
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The device's operating system type.
     * </p>
     * 
     * @return The device's operating system type.
     */
    public String os() {
        return os;
    }

    /**
     * <p>
     * Information about the device's CPU.
     * </p>
     * 
     * @return Information about the device's CPU.
     */
    public CPU cpu() {
        return cpu;
    }

    /**
     * <p>
     * The resolution of the device.
     * </p>
     * 
     * @return The resolution of the device.
     */
    public Resolution resolution() {
        return resolution;
    }

    /**
     * <p>
     * The device's heap size, expressed in bytes.
     * </p>
     * 
     * @return The device's heap size, expressed in bytes.
     */
    public Long heapSize() {
        return heapSize;
    }

    /**
     * <p>
     * The device's total memory size, expressed in bytes.
     * </p>
     * 
     * @return The device's total memory size, expressed in bytes.
     */
    public Long memory() {
        return memory;
    }

    /**
     * <p>
     * The device's image name.
     * </p>
     * 
     * @return The device's image name.
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * The device's carrier.
     * </p>
     * 
     * @return The device's carrier.
     */
    public String carrier() {
        return carrier;
    }

    /**
     * <p>
     * The device's radio.
     * </p>
     * 
     * @return The device's radio.
     */
    public String radio() {
        return radio;
    }

    /**
     * <p>
     * Specifies whether remote access has been enabled for the specified device.
     * </p>
     * 
     * @return Specifies whether remote access has been enabled for the specified device.
     */
    public Boolean remoteAccessEnabled() {
        return remoteAccessEnabled;
    }

    /**
     * <p>
     * The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
     * </p>
     * 
     * @return The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
     */
    public String fleetType() {
        return fleetType;
    }

    /**
     * <p>
     * The name of the fleet to which this device belongs.
     * </p>
     * 
     * @return The name of the fleet to which this device belongs.
     */
    public String fleetName() {
        return fleetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((manufacturer() == null) ? 0 : manufacturer().hashCode());
        hashCode = 31 * hashCode + ((model() == null) ? 0 : model().hashCode());
        hashCode = 31 * hashCode + ((formFactor() == null) ? 0 : formFactor().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((os() == null) ? 0 : os().hashCode());
        hashCode = 31 * hashCode + ((cpu() == null) ? 0 : cpu().hashCode());
        hashCode = 31 * hashCode + ((resolution() == null) ? 0 : resolution().hashCode());
        hashCode = 31 * hashCode + ((heapSize() == null) ? 0 : heapSize().hashCode());
        hashCode = 31 * hashCode + ((memory() == null) ? 0 : memory().hashCode());
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        hashCode = 31 * hashCode + ((carrier() == null) ? 0 : carrier().hashCode());
        hashCode = 31 * hashCode + ((radio() == null) ? 0 : radio().hashCode());
        hashCode = 31 * hashCode + ((remoteAccessEnabled() == null) ? 0 : remoteAccessEnabled().hashCode());
        hashCode = 31 * hashCode + ((fleetType() == null) ? 0 : fleetType().hashCode());
        hashCode = 31 * hashCode + ((fleetName() == null) ? 0 : fleetName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.manufacturer() == null ^ this.manufacturer() == null) {
            return false;
        }
        if (other.manufacturer() != null && !other.manufacturer().equals(this.manufacturer())) {
            return false;
        }
        if (other.model() == null ^ this.model() == null) {
            return false;
        }
        if (other.model() != null && !other.model().equals(this.model())) {
            return false;
        }
        if (other.formFactor() == null ^ this.formFactor() == null) {
            return false;
        }
        if (other.formFactor() != null && !other.formFactor().equals(this.formFactor())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.cpu() == null ^ this.cpu() == null) {
            return false;
        }
        if (other.cpu() != null && !other.cpu().equals(this.cpu())) {
            return false;
        }
        if (other.resolution() == null ^ this.resolution() == null) {
            return false;
        }
        if (other.resolution() != null && !other.resolution().equals(this.resolution())) {
            return false;
        }
        if (other.heapSize() == null ^ this.heapSize() == null) {
            return false;
        }
        if (other.heapSize() != null && !other.heapSize().equals(this.heapSize())) {
            return false;
        }
        if (other.memory() == null ^ this.memory() == null) {
            return false;
        }
        if (other.memory() != null && !other.memory().equals(this.memory())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.carrier() == null ^ this.carrier() == null) {
            return false;
        }
        if (other.carrier() != null && !other.carrier().equals(this.carrier())) {
            return false;
        }
        if (other.radio() == null ^ this.radio() == null) {
            return false;
        }
        if (other.radio() != null && !other.radio().equals(this.radio())) {
            return false;
        }
        if (other.remoteAccessEnabled() == null ^ this.remoteAccessEnabled() == null) {
            return false;
        }
        if (other.remoteAccessEnabled() != null && !other.remoteAccessEnabled().equals(this.remoteAccessEnabled())) {
            return false;
        }
        if (other.fleetType() == null ^ this.fleetType() == null) {
            return false;
        }
        if (other.fleetType() != null && !other.fleetType().equals(this.fleetType())) {
            return false;
        }
        if (other.fleetName() == null ^ this.fleetName() == null) {
            return false;
        }
        if (other.fleetName() != null && !other.fleetName().equals(this.fleetName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (manufacturer() != null) {
            sb.append("Manufacturer: ").append(manufacturer()).append(",");
        }
        if (model() != null) {
            sb.append("Model: ").append(model()).append(",");
        }
        if (formFactor() != null) {
            sb.append("FormFactor: ").append(formFactor()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (os() != null) {
            sb.append("Os: ").append(os()).append(",");
        }
        if (cpu() != null) {
            sb.append("Cpu: ").append(cpu()).append(",");
        }
        if (resolution() != null) {
            sb.append("Resolution: ").append(resolution()).append(",");
        }
        if (heapSize() != null) {
            sb.append("HeapSize: ").append(heapSize()).append(",");
        }
        if (memory() != null) {
            sb.append("Memory: ").append(memory()).append(",");
        }
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (carrier() != null) {
            sb.append("Carrier: ").append(carrier()).append(",");
        }
        if (radio() != null) {
            sb.append("Radio: ").append(radio()).append(",");
        }
        if (remoteAccessEnabled() != null) {
            sb.append("RemoteAccessEnabled: ").append(remoteAccessEnabled()).append(",");
        }
        if (fleetType() != null) {
            sb.append("FleetType: ").append(fleetType()).append(",");
        }
        if (fleetName() != null) {
            sb.append("FleetName: ").append(fleetName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param arn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device's display name.
         * </p>
         * 
         * @param name
         *        The device's display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device's manufacturer name.
         * </p>
         * 
         * @param manufacturer
         *        The device's manufacturer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturer(String manufacturer);

        /**
         * <p>
         * The device's model name.
         * </p>
         * 
         * @param model
         *        The device's model name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The device's form factor.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE: The phone form factor.
         * </p>
         * </li>
         * <li>
         * <p>
         * TABLET: The tablet form factor.
         * </p>
         * </li>
         * </ul>
         * 
         * @param formFactor
         *        The device's form factor.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE: The phone form factor.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TABLET: The tablet form factor.
         *        </p>
         *        </li>
         * @see DeviceFormFactor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceFormFactor
         */
        Builder formFactor(String formFactor);

        /**
         * <p>
         * The device's form factor.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE: The phone form factor.
         * </p>
         * </li>
         * <li>
         * <p>
         * TABLET: The tablet form factor.
         * </p>
         * </li>
         * </ul>
         * 
         * @param formFactor
         *        The device's form factor.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE: The phone form factor.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TABLET: The tablet form factor.
         *        </p>
         *        </li>
         * @see DeviceFormFactor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceFormFactor
         */
        Builder formFactor(DeviceFormFactor formFactor);

        /**
         * <p>
         * The device's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID: The Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS: The iOS platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The device's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID: The Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS: The iOS platform.
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The device's platform.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID: The Android platform.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS: The iOS platform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param platform
         *        The device's platform.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID: The Android platform.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS: The iOS platform.
         *        </p>
         *        </li>
         * @see DevicePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DevicePlatform
         */
        Builder platform(DevicePlatform platform);

        /**
         * <p>
         * The device's operating system type.
         * </p>
         * 
         * @param os
         *        The device's operating system type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * Information about the device's CPU.
         * </p>
         * 
         * @param cpu
         *        Information about the device's CPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(CPU cpu);

        /**
         * <p>
         * The resolution of the device.
         * </p>
         * 
         * @param resolution
         *        The resolution of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(Resolution resolution);

        /**
         * <p>
         * The device's heap size, expressed in bytes.
         * </p>
         * 
         * @param heapSize
         *        The device's heap size, expressed in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heapSize(Long heapSize);

        /**
         * <p>
         * The device's total memory size, expressed in bytes.
         * </p>
         * 
         * @param memory
         *        The device's total memory size, expressed in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Long memory);

        /**
         * <p>
         * The device's image name.
         * </p>
         * 
         * @param image
         *        The device's image name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The device's carrier.
         * </p>
         * 
         * @param carrier
         *        The device's carrier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrier(String carrier);

        /**
         * <p>
         * The device's radio.
         * </p>
         * 
         * @param radio
         *        The device's radio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radio(String radio);

        /**
         * <p>
         * Specifies whether remote access has been enabled for the specified device.
         * </p>
         * 
         * @param remoteAccessEnabled
         *        Specifies whether remote access has been enabled for the specified device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessEnabled(Boolean remoteAccessEnabled);

        /**
         * <p>
         * The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
         * </p>
         * 
         * @param fleetType
         *        The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE and PUBLIC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * The name of the fleet to which this device belongs.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet to which this device belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String manufacturer;

        private String model;

        private String formFactor;

        private String platform;

        private String os;

        private CPU cpu;

        private Resolution resolution;

        private Long heapSize;

        private Long memory;

        private String image;

        private String carrier;

        private String radio;

        private Boolean remoteAccessEnabled;

        private String fleetType;

        private String fleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            setArn(model.arn);
            setName(model.name);
            setManufacturer(model.manufacturer);
            setModel(model.model);
            setFormFactor(model.formFactor);
            setPlatform(model.platform);
            setOs(model.os);
            setCpu(model.cpu);
            setResolution(model.resolution);
            setHeapSize(model.heapSize);
            setMemory(model.memory);
            setImage(model.image);
            setCarrier(model.carrier);
            setRadio(model.radio);
            setRemoteAccessEnabled(model.remoteAccessEnabled);
            setFleetType(model.fleetType);
            setFleetName(model.fleetName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public final String getModel() {
            return model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getFormFactor() {
            return formFactor;
        }

        @Override
        public final Builder formFactor(String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        @Override
        public final Builder formFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor.toString());
            return this;
        }

        public final void setFormFactor(String formFactor) {
            this.formFactor = formFactor;
        }

        public final void setFormFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor.toString());
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(DevicePlatform platform) {
            this.platform(platform.toString());
        }

        public final String getOs() {
            return os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final CPU getCpu() {
            return cpu;
        }

        @Override
        public final Builder cpu(CPU cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(CPU cpu) {
            this.cpu = cpu;
        }

        public final Resolution getResolution() {
            return resolution;
        }

        @Override
        public final Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(Resolution resolution) {
            this.resolution = resolution;
        }

        public final Long getHeapSize() {
            return heapSize;
        }

        @Override
        public final Builder heapSize(Long heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public final void setHeapSize(Long heapSize) {
            this.heapSize = heapSize;
        }

        public final Long getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getCarrier() {
            return carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        public final String getRadio() {
            return radio;
        }

        @Override
        public final Builder radio(String radio) {
            this.radio = radio;
            return this;
        }

        public final void setRadio(String radio) {
            this.radio = radio;
        }

        public final Boolean getRemoteAccessEnabled() {
            return remoteAccessEnabled;
        }

        @Override
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        public final String getFleetType() {
            return fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        @Override
        public Device build() {
            return new Device(this);
        }
    }
}
