/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.DevicePoolCompatibilityResultMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device pool compatibility result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DevicePoolCompatibilityResult implements StructuredPojo,
        ToCopyableBuilder<DevicePoolCompatibilityResult.Builder, DevicePoolCompatibilityResult> {
    private final Device device;

    private final Boolean compatible;

    private final List<IncompatibilityMessage> incompatibilityMessages;

    private DevicePoolCompatibilityResult(BuilderImpl builder) {
        this.device = builder.device;
        this.compatible = builder.compatible;
        this.incompatibilityMessages = builder.incompatibilityMessages;
    }

    /**
     * <p>
     * The device (phone or tablet) that you wish to return information about.
     * </p>
     * 
     * @return The device (phone or tablet) that you wish to return information about.
     */
    public Device device() {
        return device;
    }

    /**
     * <p>
     * Whether the result was compatible with the device pool.
     * </p>
     * 
     * @return Whether the result was compatible with the device pool.
     */
    public Boolean compatible() {
        return compatible;
    }

    /**
     * <p>
     * Information about the compatibility.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the compatibility.
     */
    public List<IncompatibilityMessage> incompatibilityMessages() {
        return incompatibilityMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((compatible() == null) ? 0 : compatible().hashCode());
        hashCode = 31 * hashCode + ((incompatibilityMessages() == null) ? 0 : incompatibilityMessages().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePoolCompatibilityResult)) {
            return false;
        }
        DevicePoolCompatibilityResult other = (DevicePoolCompatibilityResult) obj;
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.compatible() == null ^ this.compatible() == null) {
            return false;
        }
        if (other.compatible() != null && !other.compatible().equals(this.compatible())) {
            return false;
        }
        if (other.incompatibilityMessages() == null ^ this.incompatibilityMessages() == null) {
            return false;
        }
        if (other.incompatibilityMessages() != null && !other.incompatibilityMessages().equals(this.incompatibilityMessages())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (compatible() != null) {
            sb.append("Compatible: ").append(compatible()).append(",");
        }
        if (incompatibilityMessages() != null) {
            sb.append("IncompatibilityMessages: ").append(incompatibilityMessages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DevicePoolCompatibilityResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DevicePoolCompatibilityResult> {
        /**
         * <p>
         * The device (phone or tablet) that you wish to return information about.
         * </p>
         * 
         * @param device
         *        The device (phone or tablet) that you wish to return information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * Whether the result was compatible with the device pool.
         * </p>
         * 
         * @param compatible
         *        Whether the result was compatible with the device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatible(Boolean compatible);

        /**
         * <p>
         * Information about the compatibility.
         * </p>
         * 
         * @param incompatibilityMessages
         *        Information about the compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages);

        /**
         * <p>
         * Information about the compatibility.
         * </p>
         * 
         * @param incompatibilityMessages
         *        Information about the compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibilityMessages(IncompatibilityMessage... incompatibilityMessages);
    }

    private static final class BuilderImpl implements Builder {
        private Device device;

        private Boolean compatible;

        private List<IncompatibilityMessage> incompatibilityMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePoolCompatibilityResult model) {
            setDevice(model.device);
            setCompatible(model.compatible);
            setIncompatibilityMessages(model.incompatibilityMessages);
        }

        public final Device getDevice() {
            return device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        public final Boolean getCompatible() {
            return compatible;
        }

        @Override
        public final Builder compatible(Boolean compatible) {
            this.compatible = compatible;
            return this;
        }

        public final void setCompatible(Boolean compatible) {
            this.compatible = compatible;
        }

        public final Collection<IncompatibilityMessage> getIncompatibilityMessages() {
            return incompatibilityMessages;
        }

        @Override
        public final Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibilityMessages(IncompatibilityMessage... incompatibilityMessages) {
            incompatibilityMessages(Arrays.asList(incompatibilityMessages));
            return this;
        }

        public final void setIncompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
        }

        @SafeVarargs
        public final void setIncompatibilityMessages(IncompatibilityMessage... incompatibilityMessages) {
            incompatibilityMessages(Arrays.asList(incompatibilityMessages));
        }

        @Override
        public DevicePoolCompatibilityResult build() {
            return new DevicePoolCompatibilityResult(this);
        }
    }
}
