/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the get device pool compatibility operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDevicePoolCompatibilityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetDevicePoolCompatibilityRequest.Builder, GetDevicePoolCompatibilityRequest> {
    private final String devicePoolArn;

    private final String appArn;

    private final String testType;

    private final ScheduleRunTest test;

    private GetDevicePoolCompatibilityRequest(BuilderImpl builder) {
        this.devicePoolArn = builder.devicePoolArn;
        this.appArn = builder.appArn;
        this.testType = builder.testType;
        this.test = builder.test;
    }

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @return The device pool's ARN.
     */
    public String devicePoolArn() {
        return devicePoolArn;
    }

    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     * 
     * @return The ARN of the app that is associated with the specified device pool.
     */
    public String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The test type for the specified device pool.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String testType() {
        return testType;
    }

    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     * 
     * @return Information about the uploaded test to be run against the device pool.
     */
    public ScheduleRunTest test() {
        return test;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((devicePoolArn() == null) ? 0 : devicePoolArn().hashCode());
        hashCode = 31 * hashCode + ((appArn() == null) ? 0 : appArn().hashCode());
        hashCode = 31 * hashCode + ((testType() == null) ? 0 : testType().hashCode());
        hashCode = 31 * hashCode + ((test() == null) ? 0 : test().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityRequest)) {
            return false;
        }
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest) obj;
        if (other.devicePoolArn() == null ^ this.devicePoolArn() == null) {
            return false;
        }
        if (other.devicePoolArn() != null && !other.devicePoolArn().equals(this.devicePoolArn())) {
            return false;
        }
        if (other.appArn() == null ^ this.appArn() == null) {
            return false;
        }
        if (other.appArn() != null && !other.appArn().equals(this.appArn())) {
            return false;
        }
        if (other.testType() == null ^ this.testType() == null) {
            return false;
        }
        if (other.testType() != null && !other.testType().equals(this.testType())) {
            return false;
        }
        if (other.test() == null ^ this.test() == null) {
            return false;
        }
        if (other.test() != null && !other.test().equals(this.test())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (devicePoolArn() != null) {
            sb.append("DevicePoolArn: ").append(devicePoolArn()).append(",");
        }
        if (appArn() != null) {
            sb.append("AppArn: ").append(appArn()).append(",");
        }
        if (testType() != null) {
            sb.append("TestType: ").append(testType()).append(",");
        }
        if (test() != null) {
            sb.append("Test: ").append(test()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
        /**
         * <p>
         * The device pool's ARN.
         * </p>
         * 
         * @param devicePoolArn
         *        The device pool's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePoolArn(String devicePoolArn);

        /**
         * <p>
         * The ARN of the app that is associated with the specified device pool.
         * </p>
         * 
         * @param appArn
         *        The ARN of the app that is associated with the specified device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The test type for the specified device pool.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param testType
         *        The test type for the specified device pool.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder testType(String testType);

        /**
         * <p>
         * The test type for the specified device pool.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param testType
         *        The test type for the specified device pool.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder testType(TestType testType);

        /**
         * <p>
         * Information about the uploaded test to be run against the device pool.
         * </p>
         * 
         * @param test
         *        Information about the uploaded test to be run against the device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ScheduleRunTest test);
    }

    private static final class BuilderImpl implements Builder {
        private String devicePoolArn;

        private String appArn;

        private String testType;

        private ScheduleRunTest test;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityRequest model) {
            setDevicePoolArn(model.devicePoolArn);
            setAppArn(model.appArn);
            setTestType(model.testType);
            setTest(model.test);
        }

        public final String getDevicePoolArn() {
            return devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getAppArn() {
            return appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getTestType() {
            return testType;
        }

        @Override
        public final Builder testType(String testType) {
            this.testType = testType;
            return this;
        }

        @Override
        public final Builder testType(TestType testType) {
            this.testType(testType.toString());
            return this;
        }

        public final void setTestType(String testType) {
            this.testType = testType;
        }

        public final void setTestType(TestType testType) {
            this.testType(testType.toString());
        }

        public final ScheduleRunTest getTest() {
            return test;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest test) {
            this.test = test;
        }

        @Override
        public GetDevicePoolCompatibilityRequest build() {
            return new GetDevicePoolCompatibilityRequest(this);
        }
    }
}
