/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get job request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetJobResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetJobResponse.Builder, GetJobResponse> {
    private final Job job;

    private GetJobResponse(BuilderImpl builder) {
        this.job = builder.job;
    }

    /**
     * <p>
     * An object containing information about the requested job.
     * </p>
     * 
     * @return An object containing information about the requested job.
     */
    public Job job() {
        return job;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((job() == null) ? 0 : job().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobResponse)) {
            return false;
        }
        GetJobResponse other = (GetJobResponse) obj;
        if (other.job() == null ^ this.job() == null) {
            return false;
        }
        if (other.job() != null && !other.job().equals(this.job())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (job() != null) {
            sb.append("Job: ").append(job()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetJobResponse> {
        /**
         * <p>
         * An object containing information about the requested job.
         * </p>
         * 
         * @param job
         *        An object containing information about the requested job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(Job job);
    }

    private static final class BuilderImpl implements Builder {
        private Job job;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobResponse model) {
            setJob(model.job);
        }

        public final Job getJob() {
            return job;
        }

        @Override
        public final Builder job(Job job) {
            this.job = job;
            return this;
        }

        public final void setJob(Job job) {
            this.job = job;
        }

        @Override
        public GetJobResponse build() {
            return new GetJobResponse(this);
        }
    }
}
