/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list jobs request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListJobsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private final List<Job> jobs;

    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        this.jobs = builder.jobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the jobs.
     */
    public List<Job> jobs() {
        return jobs;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobs() == null) ? 0 : jobs().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        if (other.jobs() != null && !other.jobs().equals(this.jobs())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobs() != null) {
            sb.append("Jobs: ").append(jobs()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * Information about the jobs.
         * </p>
         * 
         * @param jobs
         *        Information about the jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<Job> jobs);

        /**
         * <p>
         * Information about the jobs.
         * </p>
         * 
         * @param jobs
         *        Information about the jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Job... jobs);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Job> jobs;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            setJobs(model.jobs);
            setNextToken(model.nextToken);
        }

        public final Collection<Job> getJobs() {
            return jobs;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<Job> jobs) {
            this.jobs = JobsCopier.copy(jobs);
        }

        @SafeVarargs
        public final void setJobs(Job... jobs) {
            jobs(Arrays.asList(jobs));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }
    }
}
