/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the transaction log of the specified offerings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOfferingTransactionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOfferingTransactionsResponse.Builder, ListOfferingTransactionsResponse> {
    private final List<OfferingTransaction> offeringTransactions;

    private final String nextToken;

    private ListOfferingTransactionsResponse(BuilderImpl builder) {
        this.offeringTransactions = builder.offeringTransactions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The audit log of subscriptions you have purchased and modified through AWS Device Farm.
     */
    public List<OfferingTransaction> offeringTransactions() {
        return offeringTransactions;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((offeringTransactions() == null) ? 0 : offeringTransactions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingTransactionsResponse)) {
            return false;
        }
        ListOfferingTransactionsResponse other = (ListOfferingTransactionsResponse) obj;
        if (other.offeringTransactions() == null ^ this.offeringTransactions() == null) {
            return false;
        }
        if (other.offeringTransactions() != null && !other.offeringTransactions().equals(this.offeringTransactions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (offeringTransactions() != null) {
            sb.append("OfferingTransactions: ").append(offeringTransactions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOfferingTransactionsResponse> {
        /**
         * <p>
         * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * </p>
         * 
         * @param offeringTransactions
         *        The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions);

        /**
         * <p>
         * The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * </p>
         * 
         * @param offeringTransactions
         *        The audit log of subscriptions you have purchased and modified through AWS Device Farm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransactions(OfferingTransaction... offeringTransactions);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<OfferingTransaction> offeringTransactions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingTransactionsResponse model) {
            setOfferingTransactions(model.offeringTransactions);
            setNextToken(model.nextToken);
        }

        public final Collection<OfferingTransaction> getOfferingTransactions() {
            return offeringTransactions;
        }

        @Override
        public final Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(OfferingTransaction... offeringTransactions) {
            offeringTransactions(Arrays.asList(offeringTransactions));
            return this;
        }

        public final void setOfferingTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
        }

        @SafeVarargs
        public final void setOfferingTransactions(OfferingTransaction... offeringTransactions) {
            offeringTransactions(Arrays.asList(offeringTransactions));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingTransactionsResponse build() {
            return new ListOfferingTransactionsResponse(this);
        }
    }
}
