/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list tests request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTestsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTestsResponse.Builder, ListTestsResponse> {
    private final List<Test> tests;

    private final String nextToken;

    private ListTestsResponse(BuilderImpl builder) {
        this.tests = builder.tests;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the tests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the tests.
     */
    public List<Test> tests() {
        return tests;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tests() == null) ? 0 : tests().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestsResponse)) {
            return false;
        }
        ListTestsResponse other = (ListTestsResponse) obj;
        if (other.tests() == null ^ this.tests() == null) {
            return false;
        }
        if (other.tests() != null && !other.tests().equals(this.tests())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tests() != null) {
            sb.append("Tests: ").append(tests()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTestsResponse> {
        /**
         * <p>
         * Information about the tests.
         * </p>
         * 
         * @param tests
         *        Information about the tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tests(Collection<Test> tests);

        /**
         * <p>
         * Information about the tests.
         * </p>
         * 
         * @param tests
         *        Information about the tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tests(Test... tests);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Test> tests;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestsResponse model) {
            setTests(model.tests);
            setNextToken(model.nextToken);
        }

        public final Collection<Test> getTests() {
            return tests;
        }

        @Override
        public final Builder tests(Collection<Test> tests) {
            this.tests = TestsCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Test... tests) {
            tests(Arrays.asList(tests));
            return this;
        }

        public final void setTests(Collection<Test> tests) {
            this.tests = TestsCopier.copy(tests);
        }

        @SafeVarargs
        public final void setTests(Test... tests) {
            tests(Arrays.asList(tests));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestsResponse build() {
            return new ListTestsResponse(this);
        }
    }
}
