/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ProblemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific warning or failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Problem implements StructuredPojo, ToCopyableBuilder<Problem.Builder, Problem> {
    private final ProblemDetail run;

    private final ProblemDetail job;

    private final ProblemDetail suite;

    private final ProblemDetail test;

    private final Device device;

    private final String result;

    private final String message;

    private Problem(BuilderImpl builder) {
        this.run = builder.run;
        this.job = builder.job;
        this.suite = builder.suite;
        this.test = builder.test;
        this.device = builder.device;
        this.result = builder.result;
        this.message = builder.message;
    }

    /**
     * <p>
     * Information about the associated run.
     * </p>
     * 
     * @return Information about the associated run.
     */
    public ProblemDetail run() {
        return run;
    }

    /**
     * <p>
     * Information about the associated job.
     * </p>
     * 
     * @return Information about the associated job.
     */
    public ProblemDetail job() {
        return job;
    }

    /**
     * <p>
     * Information about the associated suite.
     * </p>
     * 
     * @return Information about the associated suite.
     */
    public ProblemDetail suite() {
        return suite;
    }

    /**
     * <p>
     * Information about the associated test.
     * </p>
     * 
     * @return Information about the associated test.
     */
    public ProblemDetail test() {
        return test;
    }

    /**
     * <p>
     * Information about the associated device.
     * </p>
     * 
     * @return Information about the associated device.
     */
    public Device device() {
        return device;
    }

    /**
     * <p>
     * The problem's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The problem's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String result() {
        return result;
    }

    /**
     * <p>
     * A message about the problem's result.
     * </p>
     * 
     * @return A message about the problem's result.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((run() == null) ? 0 : run().hashCode());
        hashCode = 31 * hashCode + ((job() == null) ? 0 : job().hashCode());
        hashCode = 31 * hashCode + ((suite() == null) ? 0 : suite().hashCode());
        hashCode = 31 * hashCode + ((test() == null) ? 0 : test().hashCode());
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((result() == null) ? 0 : result().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem) obj;
        if (other.run() == null ^ this.run() == null) {
            return false;
        }
        if (other.run() != null && !other.run().equals(this.run())) {
            return false;
        }
        if (other.job() == null ^ this.job() == null) {
            return false;
        }
        if (other.job() != null && !other.job().equals(this.job())) {
            return false;
        }
        if (other.suite() == null ^ this.suite() == null) {
            return false;
        }
        if (other.suite() != null && !other.suite().equals(this.suite())) {
            return false;
        }
        if (other.test() == null ^ this.test() == null) {
            return false;
        }
        if (other.test() != null && !other.test().equals(this.test())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (run() != null) {
            sb.append("Run: ").append(run()).append(",");
        }
        if (job() != null) {
            sb.append("Job: ").append(job()).append(",");
        }
        if (suite() != null) {
            sb.append("Suite: ").append(suite()).append(",");
        }
        if (test() != null) {
            sb.append("Test: ").append(test()).append(",");
        }
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProblemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Problem> {
        /**
         * <p>
         * Information about the associated run.
         * </p>
         * 
         * @param run
         *        Information about the associated run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(ProblemDetail run);

        /**
         * <p>
         * Information about the associated job.
         * </p>
         * 
         * @param job
         *        Information about the associated job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(ProblemDetail job);

        /**
         * <p>
         * Information about the associated suite.
         * </p>
         * 
         * @param suite
         *        Information about the associated suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suite(ProblemDetail suite);

        /**
         * <p>
         * Information about the associated test.
         * </p>
         * 
         * @param test
         *        Information about the associated test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ProblemDetail test);

        /**
         * <p>
         * Information about the associated device.
         * </p>
         * 
         * @param device
         *        Information about the associated device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The problem's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The problem's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The problem's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The problem's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * A message about the problem's result.
         * </p>
         * 
         * @param message
         *        A message about the problem's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private ProblemDetail run;

        private ProblemDetail job;

        private ProblemDetail suite;

        private ProblemDetail test;

        private Device device;

        private String result;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            setRun(model.run);
            setJob(model.job);
            setSuite(model.suite);
            setTest(model.test);
            setDevice(model.device);
            setResult(model.result);
            setMessage(model.message);
        }

        public final ProblemDetail getRun() {
            return run;
        }

        @Override
        public final Builder run(ProblemDetail run) {
            this.run = run;
            return this;
        }

        public final void setRun(ProblemDetail run) {
            this.run = run;
        }

        public final ProblemDetail getJob() {
            return job;
        }

        @Override
        public final Builder job(ProblemDetail job) {
            this.job = job;
            return this;
        }

        public final void setJob(ProblemDetail job) {
            this.job = job;
        }

        public final ProblemDetail getSuite() {
            return suite;
        }

        @Override
        public final Builder suite(ProblemDetail suite) {
            this.suite = suite;
            return this;
        }

        public final void setSuite(ProblemDetail suite) {
            this.suite = suite;
        }

        public final ProblemDetail getTest() {
            return test;
        }

        @Override
        public final Builder test(ProblemDetail test) {
            this.test = test;
            return this;
        }

        public final void setTest(ProblemDetail test) {
            this.test = test;
        }

        public final Device getDevice() {
            return device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final void setResult(ExecutionResult result) {
            this.result(result.toString());
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Problem build() {
            return new Problem(this);
        }
    }
}
