/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RemoteAccessSessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RemoteAccessSession implements StructuredPojo, ToCopyableBuilder<RemoteAccessSession.Builder, RemoteAccessSession> {
    private final String arn;

    private final String name;

    private final Instant created;

    private final String status;

    private final String result;

    private final String message;

    private final Instant started;

    private final Instant stopped;

    private final Device device;

    private final String billingMethod;

    private final DeviceMinutes deviceMinutes;

    private final String endpoint;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the remote access session.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the remote access session.
     * </p>
     * 
     * @return The name of the remote access session.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The date and time the remote access session was created.
     * </p>
     * 
     * @return The date and time the remote access session was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The status of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The result of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The result of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String result() {
        return result;
    }

    /**
     * <p>
     * A message about the remote access session.
     * </p>
     * 
     * @return A message about the remote access session.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The date and time the remote access session was started.
     * </p>
     * 
     * @return The date and time the remote access session was started.
     */
    public Instant started() {
        return started;
    }

    /**
     * <p>
     * The date and time the remote access session was stopped.
     * </p>
     * 
     * @return The date and time the remote access session was stopped.
     */
    public Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The device (phone or tablet) used in the remote access session.
     * </p>
     * 
     * @return The device (phone or tablet) used in the remote access session.
     */
    public Device device() {
        return device;
    }

    /**
     * <p>
     * The billing method of the remote access session. Possible values include <code>METERED</code> or
     * <code>UNMETERED</code>. For more information about metered devices, see <a
     * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device
     * Farm terminology</a>."
     * </p>
     * 
     * @return The billing method of the remote access session. Possible values include <code>METERED</code> or
     *         <code>UNMETERED</code>. For more information about metered devices, see <a
     *         href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
     *         Device Farm terminology</a>."
     * @see BillingMethod
     */
    public String billingMethod() {
        return billingMethod;
    }

    /**
     * <p>
     * The number of minutes a device is used in a remote access sesssion (including setup and teardown minutes).
     * </p>
     * 
     * @return The number of minutes a device is used in a remote access sesssion (including setup and teardown
     *         minutes).
     */
    public DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    /**
     * <p>
     * The endpoint for the remote access sesssion.
     * </p>
     * 
     * @return The endpoint for the remote access sesssion.
     */
    public String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((created() == null) ? 0 : created().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((result() == null) ? 0 : result().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((started() == null) ? 0 : started().hashCode());
        hashCode = 31 * hashCode + ((stopped() == null) ? 0 : stopped().hashCode());
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((billingMethod() == null) ? 0 : billingMethod().hashCode());
        hashCode = 31 * hashCode + ((deviceMinutes() == null) ? 0 : deviceMinutes().hashCode());
        hashCode = 31 * hashCode + ((endpoint() == null) ? 0 : endpoint().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.started() == null ^ this.started() == null) {
            return false;
        }
        if (other.started() != null && !other.started().equals(this.started())) {
            return false;
        }
        if (other.stopped() == null ^ this.stopped() == null) {
            return false;
        }
        if (other.stopped() != null && !other.stopped().equals(this.stopped())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.billingMethod() == null ^ this.billingMethod() == null) {
            return false;
        }
        if (other.billingMethod() != null && !other.billingMethod().equals(this.billingMethod())) {
            return false;
        }
        if (other.deviceMinutes() == null ^ this.deviceMinutes() == null) {
            return false;
        }
        if (other.deviceMinutes() != null && !other.deviceMinutes().equals(this.deviceMinutes())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (created() != null) {
            sb.append("Created: ").append(created()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (result() != null) {
            sb.append("Result: ").append(result()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (started() != null) {
            sb.append("Started: ").append(started()).append(",");
        }
        if (stopped() != null) {
            sb.append("Stopped: ").append(stopped()).append(",");
        }
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (billingMethod() != null) {
            sb.append("BillingMethod: ").append(billingMethod()).append(",");
        }
        if (deviceMinutes() != null) {
            sb.append("DeviceMinutes: ").append(deviceMinutes()).append(",");
        }
        if (endpoint() != null) {
            sb.append("Endpoint: ").append(endpoint()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemoteAccessSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RemoteAccessSession> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the remote access session.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the remote access session.
         * </p>
         * 
         * @param name
         *        The name of the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time the remote access session was created.
         * </p>
         * 
         * @param created
         *        The date and time the remote access session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The status of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The result of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The result of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The result of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The result of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * A message about the remote access session.
         * </p>
         * 
         * @param message
         *        A message about the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The date and time the remote access session was started.
         * </p>
         * 
         * @param started
         *        The date and time the remote access session was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The date and time the remote access session was stopped.
         * </p>
         * 
         * @param stopped
         *        The date and time the remote access session was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The device (phone or tablet) used in the remote access session.
         * </p>
         * 
         * @param device
         *        The device (phone or tablet) used in the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The billing method of the remote access session. Possible values include <code>METERED</code> or
         * <code>UNMETERED</code>. For more information about metered devices, see <a
         * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
         * Device Farm terminology</a>."
         * </p>
         * 
         * @param billingMethod
         *        The billing method of the remote access session. Possible values include <code>METERED</code> or
         *        <code>UNMETERED</code>. For more information about metered devices, see <a
         *        href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology"
         *        >AWS Device Farm terminology</a>."
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * The billing method of the remote access session. Possible values include <code>METERED</code> or
         * <code>UNMETERED</code>. For more information about metered devices, see <a
         * href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
         * Device Farm terminology</a>."
         * </p>
         * 
         * @param billingMethod
         *        The billing method of the remote access session. Possible values include <code>METERED</code> or
         *        <code>UNMETERED</code>. For more information about metered devices, see <a
         *        href="http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology"
         *        >AWS Device Farm terminology</a>."
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);

        /**
         * <p>
         * The number of minutes a device is used in a remote access sesssion (including setup and teardown minutes).
         * </p>
         * 
         * @param deviceMinutes
         *        The number of minutes a device is used in a remote access sesssion (including setup and teardown
         *        minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * The endpoint for the remote access sesssion.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the remote access sesssion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant created;

        private String status;

        private String result;

        private String message;

        private Instant started;

        private Instant stopped;

        private Device device;

        private String billingMethod;

        private DeviceMinutes deviceMinutes;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            setArn(model.arn);
            setName(model.name);
            setCreated(model.created);
            setStatus(model.status);
            setResult(model.result);
            setMessage(model.message);
            setStarted(model.started);
            setStopped(model.stopped);
            setDevice(model.device);
            setBillingMethod(model.billingMethod);
            setDeviceMinutes(model.deviceMinutes);
            setEndpoint(model.endpoint);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final void setResult(ExecutionResult result) {
            this.result(result.toString());
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getStarted() {
            return started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Device getDevice() {
            return device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final void setBillingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
        }

        public final DeviceMinutes getDeviceMinutes() {
            return deviceMinutes;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }
    }
}
