/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the schedule run operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleRunRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ScheduleRunRequest.Builder, ScheduleRunRequest> {
    private final String projectArn;

    private final String appArn;

    private final String devicePoolArn;

    private final String name;

    private final ScheduleRunTest test;

    private final ScheduleRunConfiguration configuration;

    private final ExecutionConfiguration executionConfiguration;

    private ScheduleRunRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.appArn = builder.appArn;
        this.devicePoolArn = builder.devicePoolArn;
        this.name = builder.name;
        this.test = builder.test;
        this.configuration = builder.configuration;
        this.executionConfiguration = builder.executionConfiguration;
    }

    /**
     * <p>
     * The ARN of the project for the run to be scheduled.
     * </p>
     * 
     * @return The ARN of the project for the run to be scheduled.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The ARN of the app to schedule a run.
     * </p>
     * 
     * @return The ARN of the app to schedule a run.
     */
    public String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The ARN of the device pool for the run to be scheduled.
     * </p>
     * 
     * @return The ARN of the device pool for the run to be scheduled.
     */
    public String devicePoolArn() {
        return devicePoolArn;
    }

    /**
     * <p>
     * The name for the run to be scheduled.
     * </p>
     * 
     * @return The name for the run to be scheduled.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Information about the test for the run to be scheduled.
     * </p>
     * 
     * @return Information about the test for the run to be scheduled.
     */
    public ScheduleRunTest test() {
        return test;
    }

    /**
     * <p>
     * Information about the settings for the run to be scheduled.
     * </p>
     * 
     * @return Information about the settings for the run to be scheduled.
     */
    public ScheduleRunConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Specifies configuration information about a test run, such as the execution timeout (in minutes).
     * </p>
     * 
     * @return Specifies configuration information about a test run, such as the execution timeout (in minutes).
     */
    public ExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((projectArn() == null) ? 0 : projectArn().hashCode());
        hashCode = 31 * hashCode + ((appArn() == null) ? 0 : appArn().hashCode());
        hashCode = 31 * hashCode + ((devicePoolArn() == null) ? 0 : devicePoolArn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((test() == null) ? 0 : test().hashCode());
        hashCode = 31 * hashCode + ((configuration() == null) ? 0 : configuration().hashCode());
        hashCode = 31 * hashCode + ((executionConfiguration() == null) ? 0 : executionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunRequest)) {
            return false;
        }
        ScheduleRunRequest other = (ScheduleRunRequest) obj;
        if (other.projectArn() == null ^ this.projectArn() == null) {
            return false;
        }
        if (other.projectArn() != null && !other.projectArn().equals(this.projectArn())) {
            return false;
        }
        if (other.appArn() == null ^ this.appArn() == null) {
            return false;
        }
        if (other.appArn() != null && !other.appArn().equals(this.appArn())) {
            return false;
        }
        if (other.devicePoolArn() == null ^ this.devicePoolArn() == null) {
            return false;
        }
        if (other.devicePoolArn() != null && !other.devicePoolArn().equals(this.devicePoolArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.test() == null ^ this.test() == null) {
            return false;
        }
        if (other.test() != null && !other.test().equals(this.test())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        if (other.executionConfiguration() == null ^ this.executionConfiguration() == null) {
            return false;
        }
        if (other.executionConfiguration() != null && !other.executionConfiguration().equals(this.executionConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (projectArn() != null) {
            sb.append("ProjectArn: ").append(projectArn()).append(",");
        }
        if (appArn() != null) {
            sb.append("AppArn: ").append(appArn()).append(",");
        }
        if (devicePoolArn() != null) {
            sb.append("DevicePoolArn: ").append(devicePoolArn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (test() != null) {
            sb.append("Test: ").append(test()).append(",");
        }
        if (configuration() != null) {
            sb.append("Configuration: ").append(configuration()).append(",");
        }
        if (executionConfiguration() != null) {
            sb.append("ExecutionConfiguration: ").append(executionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleRunRequest> {
        /**
         * <p>
         * The ARN of the project for the run to be scheduled.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the project for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The ARN of the app to schedule a run.
         * </p>
         * 
         * @param appArn
         *        The ARN of the app to schedule a run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The ARN of the device pool for the run to be scheduled.
         * </p>
         * 
         * @param devicePoolArn
         *        The ARN of the device pool for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePoolArn(String devicePoolArn);

        /**
         * <p>
         * The name for the run to be scheduled.
         * </p>
         * 
         * @param name
         *        The name for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the test for the run to be scheduled.
         * </p>
         * 
         * @param test
         *        Information about the test for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ScheduleRunTest test);

        /**
         * <p>
         * Information about the settings for the run to be scheduled.
         * </p>
         * 
         * @param configuration
         *        Information about the settings for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ScheduleRunConfiguration configuration);

        /**
         * <p>
         * Specifies configuration information about a test run, such as the execution timeout (in minutes).
         * </p>
         * 
         * @param executionConfiguration
         *        Specifies configuration information about a test run, such as the execution timeout (in minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(ExecutionConfiguration executionConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String projectArn;

        private String appArn;

        private String devicePoolArn;

        private String name;

        private ScheduleRunTest test;

        private ScheduleRunConfiguration configuration;

        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunRequest model) {
            setProjectArn(model.projectArn);
            setAppArn(model.appArn);
            setDevicePoolArn(model.devicePoolArn);
            setName(model.name);
            setTest(model.test);
            setConfiguration(model.configuration);
            setExecutionConfiguration(model.executionConfiguration);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getAppArn() {
            return appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getDevicePoolArn() {
            return devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ScheduleRunTest getTest() {
            return test;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest test) {
            this.test = test;
        }

        public final ScheduleRunConfiguration getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
        }

        public final ExecutionConfiguration getExecutionConfiguration() {
            return executionConfiguration;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
        }

        @Override
        public ScheduleRunRequest build() {
            return new ScheduleRunRequest(this);
        }
    }
}
