/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server that describes the remote access session when AWS Device Farm stops the
 * session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopRemoteAccessSessionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<StopRemoteAccessSessionResponse.Builder, StopRemoteAccessSessionResponse> {
    private final RemoteAccessSession remoteAccessSession;

    private StopRemoteAccessSessionResponse(BuilderImpl builder) {
        this.remoteAccessSession = builder.remoteAccessSession;
    }

    /**
     * <p>
     * A container representing the metadata from the service about the remote access session you are stopping.
     * </p>
     * 
     * @return A container representing the metadata from the service about the remote access session you are stopping.
     */
    public RemoteAccessSession remoteAccessSession() {
        return remoteAccessSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((remoteAccessSession() == null) ? 0 : remoteAccessSession().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopRemoteAccessSessionResponse)) {
            return false;
        }
        StopRemoteAccessSessionResponse other = (StopRemoteAccessSessionResponse) obj;
        if (other.remoteAccessSession() == null ^ this.remoteAccessSession() == null) {
            return false;
        }
        if (other.remoteAccessSession() != null && !other.remoteAccessSession().equals(this.remoteAccessSession())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (remoteAccessSession() != null) {
            sb.append("RemoteAccessSession: ").append(remoteAccessSession()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, StopRemoteAccessSessionResponse> {
        /**
         * <p>
         * A container representing the metadata from the service about the remote access session you are stopping.
         * </p>
         * 
         * @param remoteAccessSession
         *        A container representing the metadata from the service about the remote access session you are
         *        stopping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSession(RemoteAccessSession remoteAccessSession);
    }

    private static final class BuilderImpl implements Builder {
        private RemoteAccessSession remoteAccessSession;

        private BuilderImpl() {
        }

        private BuilderImpl(StopRemoteAccessSessionResponse model) {
            setRemoteAccessSession(model.remoteAccessSession);
        }

        public final RemoteAccessSession getRemoteAccessSession() {
            return remoteAccessSession;
        }

        @Override
        public final Builder remoteAccessSession(RemoteAccessSession remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession;
            return this;
        }

        public final void setRemoteAccessSession(RemoteAccessSession remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession;
        }

        @Override
        public StopRemoteAccessSessionResponse build() {
            return new StopRemoteAccessSessionResponse(this);
        }
    }
}
