/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Counters JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CountersUnmarshaller implements Unmarshaller<Counters, JsonUnmarshallerContext> {

    public Counters unmarshall(JsonUnmarshallerContext context) throws Exception {
        Counters.Builder countersBuilder = Counters.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("total", targetDepth)) {
                    context.nextToken();
                    countersBuilder.total(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("passed", targetDepth)) {
                    context.nextToken();
                    countersBuilder.passed(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("failed", targetDepth)) {
                    context.nextToken();
                    countersBuilder.failed(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("warned", targetDepth)) {
                    context.nextToken();
                    countersBuilder.warned(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("errored", targetDepth)) {
                    context.nextToken();
                    countersBuilder.errored(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("stopped", targetDepth)) {
                    context.nextToken();
                    countersBuilder.stopped(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("skipped", targetDepth)) {
                    context.nextToken();
                    countersBuilder.skipped(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return countersBuilder.build();
    }

    private static CountersUnmarshaller INSTANCE;

    public static CountersUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CountersUnmarshaller();
        return INSTANCE;
    }
}
