/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * NetworkProfile JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NetworkProfileUnmarshaller implements Unmarshaller<NetworkProfile, JsonUnmarshallerContext> {

    public NetworkProfile unmarshall(JsonUnmarshallerContext context) throws Exception {
        NetworkProfile.Builder networkProfileBuilder = NetworkProfile.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("uplinkBandwidthBits", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.uplinkBandwidthBits(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("downlinkBandwidthBits", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.downlinkBandwidthBits(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("uplinkDelayMs", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.uplinkDelayMs(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("downlinkDelayMs", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.downlinkDelayMs(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("uplinkJitterMs", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.uplinkJitterMs(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("downlinkJitterMs", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.downlinkJitterMs(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("uplinkLossPercent", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.uplinkLossPercent(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("downlinkLossPercent", targetDepth)) {
                    context.nextToken();
                    networkProfileBuilder.downlinkLossPercent(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return networkProfileBuilder.build();
    }

    private static NetworkProfileUnmarshaller INSTANCE;

    public static NetworkProfileUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new NetworkProfileUnmarshaller();
        return INSTANCE;
    }
}
