/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Offering;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType;
import software.amazon.awssdk.services.devicefarm.transform.OfferingStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OfferingStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, OfferingStatus> {
    private final String type;
    private final Offering offering;
    private final Integer quantity;
    private final Instant effectiveOn;

    private OfferingStatus(BuilderImpl builder) {
        this.type = builder.type;
        this.offering = builder.offering;
        this.quantity = builder.quantity;
        this.effectiveOn = builder.effectiveOn;
    }

    public String type() {
        return this.type;
    }

    public Offering offering() {
        return this.offering;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public Instant effectiveOn() {
        return this.effectiveOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.offering() == null ? 0 : this.offering().hashCode());
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.effectiveOn() == null ? 0 : this.effectiveOn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingStatus)) {
            return false;
        }
        OfferingStatus other = (OfferingStatus)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.offering() == null ^ this.offering() == null) {
            return false;
        }
        if (other.offering() != null && !other.offering().equals(this.offering())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.effectiveOn() == null ^ this.effectiveOn() == null) {
            return false;
        }
        return other.effectiveOn() == null || other.effectiveOn().equals(this.effectiveOn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.offering() != null) {
            sb.append("Offering: ").append(this.offering()).append(",");
        }
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.effectiveOn() != null) {
            sb.append("EffectiveOn: ").append(this.effectiveOn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private Offering offering;
        private Integer quantity;
        private Instant effectiveOn;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingStatus model) {
            this.setType(model.type);
            this.setOffering(model.offering);
            this.setQuantity(model.quantity);
            this.setEffectiveOn(model.effectiveOn);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingTransactionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(OfferingTransactionType type) {
            this.type(type.toString());
        }

        public final Offering getOffering() {
            return this.offering;
        }

        @Override
        public final Builder offering(Offering offering) {
            this.offering = offering;
            return this;
        }

        public final void setOffering(Offering offering) {
            this.offering = offering;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Instant getEffectiveOn() {
            return this.effectiveOn;
        }

        @Override
        public final Builder effectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        public final void setEffectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        public OfferingStatus build() {
            return new OfferingStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OfferingStatus> {
        public Builder type(String var1);

        public Builder type(OfferingTransactionType var1);

        public Builder offering(Offering var1);

        public Builder quantity(Integer var1);

        public Builder effectiveOn(Instant var1);
    }
}

