/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a create project request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateProjectResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateProjectResponse.Builder, CreateProjectResponse> {
    private final Project project;

    private CreateProjectResponse(BuilderImpl builder) {
        this.project = builder.project;
    }

    /**
     * <p>
     * The newly created project.
     * </p>
     * 
     * @return The newly created project.
     */
    public Project project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((project() == null) ? 0 : project().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectResponse)) {
            return false;
        }
        CreateProjectResponse other = (CreateProjectResponse) obj;
        if (other.project() == null ^ this.project() == null) {
            return false;
        }
        if (other.project() != null && !other.project().equals(this.project())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (project() != null) {
            sb.append("Project: ").append(project()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateProjectResponse> {
        /**
         * <p>
         * The newly created project.
         * </p>
         * 
         * @param project
         *        The newly created project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(Project project);
    }

    private static final class BuilderImpl implements Builder {
        private Project project;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectResponse model) {
            setProject(model.project);
        }

        public final Project getProject() {
            return project;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final void setProject(Project project) {
            this.project = project;
        }

        @Override
        public CreateProjectResponse build() {
            return new CreateProjectResponse(this);
        }
    }
}
