/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates and submits a request to start a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRemoteAccessSessionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateRemoteAccessSessionRequest.Builder, CreateRemoteAccessSessionRequest> {
    private final String projectArn;

    private final String deviceArn;

    private final String name;

    private final CreateRemoteAccessSessionConfiguration configuration;

    private CreateRemoteAccessSessionRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.deviceArn = builder.deviceArn;
        this.name = builder.name;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The name of the remote access session that you wish to create.
     * </p>
     * 
     * @return The name of the remote access session that you wish to create.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The configuration information for the remote access session request.
     * </p>
     * 
     * @return The configuration information for the remote access session request.
     */
    public CreateRemoteAccessSessionConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((projectArn() == null) ? 0 : projectArn().hashCode());
        hashCode = 31 * hashCode + ((deviceArn() == null) ? 0 : deviceArn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((configuration() == null) ? 0 : configuration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionRequest)) {
            return false;
        }
        CreateRemoteAccessSessionRequest other = (CreateRemoteAccessSessionRequest) obj;
        if (other.projectArn() == null ^ this.projectArn() == null) {
            return false;
        }
        if (other.projectArn() != null && !other.projectArn().equals(this.projectArn())) {
            return false;
        }
        if (other.deviceArn() == null ^ this.deviceArn() == null) {
            return false;
        }
        if (other.deviceArn() != null && !other.deviceArn().equals(this.deviceArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (projectArn() != null) {
            sb.append("ProjectArn: ").append(projectArn()).append(",");
        }
        if (deviceArn() != null) {
            sb.append("DeviceArn: ").append(deviceArn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (configuration() != null) {
            sb.append("Configuration: ").append(configuration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project for which you want to create a remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
         * </p>
         * 
         * @param deviceArn
         *        The Amazon Resource Name (ARN) of the device for which you want to create a remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The name of the remote access session that you wish to create.
         * </p>
         * 
         * @param name
         *        The name of the remote access session that you wish to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration information for the remote access session request.
         * </p>
         * 
         * @param configuration
         *        The configuration information for the remote access session request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CreateRemoteAccessSessionConfiguration configuration);
    }

    private static final class BuilderImpl implements Builder {
        private String projectArn;

        private String deviceArn;

        private String name;

        private CreateRemoteAccessSessionConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionRequest model) {
            setProjectArn(model.projectArn);
            setDeviceArn(model.deviceArn);
            setName(model.name);
            setConfiguration(model.configuration);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final CreateRemoteAccessSessionConfiguration getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public CreateRemoteAccessSessionRequest build() {
            return new CreateRemoteAccessSessionRequest(this);
        }
    }
}
