/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ExecutionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents configuration information about a test run, such as the execution timeout (in minutes).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExecutionConfiguration implements StructuredPojo,
        ToCopyableBuilder<ExecutionConfiguration.Builder, ExecutionConfiguration> {
    private final Integer jobTimeoutMinutes;

    private final Boolean accountsCleanup;

    private final Boolean appPackagesCleanup;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.accountsCleanup = builder.accountsCleanup;
        this.appPackagesCleanup = builder.appPackagesCleanup;
    }

    /**
     * <p>
     * The number of minutes a test run will execute before it times out.
     * </p>
     * 
     * @return The number of minutes a test run will execute before it times out.
     */
    public Integer jobTimeoutMinutes() {
        return jobTimeoutMinutes;
    }

    /**
     * <p>
     * True if account cleanup is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if account cleanup is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean accountsCleanup() {
        return accountsCleanup;
    }

    /**
     * <p>
     * True if app package cleanup is enabled at the beginning of the test; otherwise, false.
     * </p>
     * 
     * @return True if app package cleanup is enabled at the beginning of the test; otherwise, false.
     */
    public Boolean appPackagesCleanup() {
        return appPackagesCleanup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jobTimeoutMinutes() == null) ? 0 : jobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + ((accountsCleanup() == null) ? 0 : accountsCleanup().hashCode());
        hashCode = 31 * hashCode + ((appPackagesCleanup() == null) ? 0 : appPackagesCleanup().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration) obj;
        if (other.jobTimeoutMinutes() == null ^ this.jobTimeoutMinutes() == null) {
            return false;
        }
        if (other.jobTimeoutMinutes() != null && !other.jobTimeoutMinutes().equals(this.jobTimeoutMinutes())) {
            return false;
        }
        if (other.accountsCleanup() == null ^ this.accountsCleanup() == null) {
            return false;
        }
        if (other.accountsCleanup() != null && !other.accountsCleanup().equals(this.accountsCleanup())) {
            return false;
        }
        if (other.appPackagesCleanup() == null ^ this.appPackagesCleanup() == null) {
            return false;
        }
        if (other.appPackagesCleanup() != null && !other.appPackagesCleanup().equals(this.appPackagesCleanup())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jobTimeoutMinutes() != null) {
            sb.append("JobTimeoutMinutes: ").append(jobTimeoutMinutes()).append(",");
        }
        if (accountsCleanup() != null) {
            sb.append("AccountsCleanup: ").append(accountsCleanup()).append(",");
        }
        if (appPackagesCleanup() != null) {
            sb.append("AppPackagesCleanup: ").append(appPackagesCleanup()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ExecutionConfiguration> {
        /**
         * <p>
         * The number of minutes a test run will execute before it times out.
         * </p>
         * 
         * @param jobTimeoutMinutes
         *        The number of minutes a test run will execute before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTimeoutMinutes(Integer jobTimeoutMinutes);

        /**
         * <p>
         * True if account cleanup is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param accountsCleanup
         *        True if account cleanup is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsCleanup(Boolean accountsCleanup);

        /**
         * <p>
         * True if app package cleanup is enabled at the beginning of the test; otherwise, false.
         * </p>
         * 
         * @param appPackagesCleanup
         *        True if app package cleanup is enabled at the beginning of the test; otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appPackagesCleanup(Boolean appPackagesCleanup);
    }

    private static final class BuilderImpl implements Builder {
        private Integer jobTimeoutMinutes;

        private Boolean accountsCleanup;

        private Boolean appPackagesCleanup;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            setJobTimeoutMinutes(model.jobTimeoutMinutes);
            setAccountsCleanup(model.accountsCleanup);
            setAppPackagesCleanup(model.appPackagesCleanup);
        }

        public final Integer getJobTimeoutMinutes() {
            return jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        public final Boolean getAccountsCleanup() {
            return accountsCleanup;
        }

        @Override
        public final Builder accountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
            return this;
        }

        public final void setAccountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
        }

        public final Boolean getAppPackagesCleanup() {
            return appPackagesCleanup;
        }

        @Override
        public final Builder appPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
            return this;
        }

        public final void setAppPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
        }

        @Override
        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }
    }
}
