/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the account settings return values from the <code>GetAccountSettings</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetAccountSettingsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetAccountSettingsResponse.Builder, GetAccountSettingsResponse> {
    private final AccountSettings accountSettings;

    private GetAccountSettingsResponse(BuilderImpl builder) {
        this.accountSettings = builder.accountSettings;
    }

    /**
     * <p>
     * The account settings.
     * </p>
     * 
     * @return The account settings.
     */
    public AccountSettings accountSettings() {
        return accountSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountSettings() == null) ? 0 : accountSettings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSettingsResponse)) {
            return false;
        }
        GetAccountSettingsResponse other = (GetAccountSettingsResponse) obj;
        if (other.accountSettings() == null ^ this.accountSettings() == null) {
            return false;
        }
        if (other.accountSettings() != null && !other.accountSettings().equals(this.accountSettings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountSettings() != null) {
            sb.append("AccountSettings: ").append(accountSettings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetAccountSettingsResponse> {
        /**
         * <p>
         * The account settings.
         * </p>
         * 
         * @param accountSettings
         *        The account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSettings(AccountSettings accountSettings);
    }

    private static final class BuilderImpl implements Builder {
        private AccountSettings accountSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSettingsResponse model) {
            setAccountSettings(model.accountSettings);
        }

        public final AccountSettings getAccountSettings() {
            return accountSettings;
        }

        @Override
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        public final void setAccountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
        }

        @Override
        public GetAccountSettingsResponse build() {
            return new GetAccountSettingsResponse(this);
        }
    }
}
