/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetNetworkProfileResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetNetworkProfileResponse.Builder, GetNetworkProfileResponse> {
    private final NetworkProfile networkProfile;

    private GetNetworkProfileResponse(BuilderImpl builder) {
        this.networkProfile = builder.networkProfile;
    }

    /**
     * <p>
     * The network profile.
     * </p>
     * 
     * @return The network profile.
     */
    public NetworkProfile networkProfile() {
        return networkProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkProfile() == null) ? 0 : networkProfile().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkProfileResponse)) {
            return false;
        }
        GetNetworkProfileResponse other = (GetNetworkProfileResponse) obj;
        if (other.networkProfile() == null ^ this.networkProfile() == null) {
            return false;
        }
        if (other.networkProfile() != null && !other.networkProfile().equals(this.networkProfile())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (networkProfile() != null) {
            sb.append("NetworkProfile: ").append(networkProfile()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetNetworkProfileResponse> {
        /**
         * <p>
         * The network profile.
         * </p>
         * 
         * @param networkProfile
         *        The network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfile(NetworkProfile networkProfile);
    }

    private static final class BuilderImpl implements Builder {
        private NetworkProfile networkProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkProfileResponse model) {
            setNetworkProfile(model.networkProfile);
        }

        public final NetworkProfile getNetworkProfile() {
            return networkProfile;
        }

        @Override
        public final Builder networkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
            return this;
        }

        public final void setNetworkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
        }

        @Override
        public GetNetworkProfileResponse build() {
            return new GetNetworkProfileResponse(this);
        }
    }
}
