/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get suite request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSuiteResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetSuiteResponse.Builder, GetSuiteResponse> {
    private final Suite suite;

    private GetSuiteResponse(BuilderImpl builder) {
        this.suite = builder.suite;
    }

    /**
     * <p>
     * A collection of one or more tests.
     * </p>
     * 
     * @return A collection of one or more tests.
     */
    public Suite suite() {
        return suite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((suite() == null) ? 0 : suite().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteResponse)) {
            return false;
        }
        GetSuiteResponse other = (GetSuiteResponse) obj;
        if (other.suite() == null ^ this.suite() == null) {
            return false;
        }
        if (other.suite() != null && !other.suite().equals(this.suite())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (suite() != null) {
            sb.append("Suite: ").append(suite()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSuiteResponse> {
        /**
         * <p>
         * A collection of one or more tests.
         * </p>
         * 
         * @param suite
         *        A collection of one or more tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suite(Suite suite);
    }

    private static final class BuilderImpl implements Builder {
        private Suite suite;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteResponse model) {
            setSuite(model.suite);
        }

        public final Suite getSuite() {
            return suite;
        }

        @Override
        public final Builder suite(Suite suite) {
            this.suite = suite;
            return this;
        }

        public final void setSuite(Suite suite) {
            this.suite = suite;
        }

        @Override
        public GetSuiteResponse build() {
            return new GetSuiteResponse(this);
        }
    }
}
