/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request for a purchase offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseOfferingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PurchaseOfferingRequest.Builder, PurchaseOfferingRequest> {
    private final String offeringId;

    private final Integer quantity;

    private final String offeringPromotionId;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.quantity = builder.quantity;
        this.offeringPromotionId = builder.offeringPromotionId;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The number of device slots you wish to purchase in an offering request.
     * </p>
     * 
     * @return The number of device slots you wish to purchase in an offering request.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The ID of the offering promotion to be applied to the purchase.
     * </p>
     * 
     * @return The ID of the offering promotion to be applied to the purchase.
     */
    public String offeringPromotionId() {
        return offeringPromotionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((offeringId() == null) ? 0 : offeringId().hashCode());
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((offeringPromotionId() == null) ? 0 : offeringPromotionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest) obj;
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.offeringPromotionId() == null ^ this.offeringPromotionId() == null) {
            return false;
        }
        if (other.offeringPromotionId() != null && !other.offeringPromotionId().equals(this.offeringPromotionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (offeringPromotionId() != null) {
            sb.append("OfferingPromotionId: ").append(offeringPromotionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseOfferingRequest> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The number of device slots you wish to purchase in an offering request.
         * </p>
         * 
         * @param quantity
         *        The number of device slots you wish to purchase in an offering request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The ID of the offering promotion to be applied to the purchase.
         * </p>
         * 
         * @param offeringPromotionId
         *        The ID of the offering promotion to be applied to the purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotionId(String offeringPromotionId);
    }

    private static final class BuilderImpl implements Builder {
        private String offeringId;

        private Integer quantity;

        private String offeringPromotionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            setOfferingId(model.offeringId);
            setQuantity(model.quantity);
            setOfferingPromotionId(model.offeringPromotionId);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final String getOfferingPromotionId() {
            return offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        @Override
        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }
    }
}
