/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition for a device pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Rule implements StructuredPojo, ToCopyableBuilder<Rule.Builder, Rule> {
    private final String attribute;

    private final String operator;

    private final String value;

    private Rule(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ARN: The ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * FORM_FACTOR: The form factor (for example, phone or tablet).
     * </p>
     * </li>
     * <li>
     * <p>
     * MANUFACTURER: The manufacturer.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM: The platform (for example, Android or iOS).
     * </p>
     * </li>
     * <li>
     * <p>
     * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_VERSION: The Appium version for the test.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ARN: The ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FORM_FACTOR: The form factor (for example, phone or tablet).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MANUFACTURER: The manufacturer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM: The platform (for example, Android or iOS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_VERSION: The Appium version for the test.
     *         </p>
     *         </li>
     * @see DeviceAttribute
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The rule's operator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * EQUALS: The equals operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * GREATER_THAN: The greater-than operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN: The in operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * LESS_THAN: The less-than operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_IN: The not-in operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONTAINS: The contains operator.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The rule's operator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         EQUALS: The equals operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GREATER_THAN: The greater-than operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN: The in operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LESS_THAN: The less-than operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_IN: The not-in operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONTAINS: The contains operator.
     *         </p>
     *         </li>
     * @see RuleOperator
     */
    public String operator() {
        return operator;
    }

    /**
     * <p>
     * The rule's value.
     * </p>
     * 
     * @return The rule's value.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attribute() == null) ? 0 : attribute().hashCode());
        hashCode = 31 * hashCode + ((operator() == null) ? 0 : operator().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.operator() == null ^ this.operator() == null) {
            return false;
        }
        if (other.operator() != null && !other.operator().equals(this.operator())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attribute() != null) {
            sb.append("Attribute: ").append(attribute()).append(",");
        }
        if (operator() != null) {
            sb.append("Operator: ").append(operator()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attribute
         *        The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ARN: The ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * FORM_FACTOR: The form factor (for example, phone or tablet).
         * </p>
         * </li>
         * <li>
         * <p>
         * MANUFACTURER: The manufacturer.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM: The platform (for example, Android or iOS).
         * </p>
         * </li>
         * <li>
         * <p>
         * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_VERSION: The Appium version for the test.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attribute
         *        The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ARN: The ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FORM_FACTOR: The form factor (for example, phone or tablet).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MANUFACTURER: The manufacturer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM: The platform (for example, Android or iOS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_VERSION: The Appium version for the test.
         *        </p>
         *        </li>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder attribute(DeviceAttribute attribute);

        /**
         * <p>
         * The rule's operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EQUALS: The equals operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * GREATER_THAN: The greater-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN: The in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * LESS_THAN: The less-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_IN: The not-in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTAINS: The contains operator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operator
         *        The rule's operator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        EQUALS: The equals operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GREATER_THAN: The greater-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN: The in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LESS_THAN: The less-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_IN: The not-in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTAINS: The contains operator.
         *        </p>
         *        </li>
         * @see RuleOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The rule's operator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * EQUALS: The equals operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * GREATER_THAN: The greater-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN: The in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * LESS_THAN: The less-than operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_IN: The not-in operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTAINS: The contains operator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operator
         *        The rule's operator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        EQUALS: The equals operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GREATER_THAN: The greater-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN: The in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LESS_THAN: The less-than operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_IN: The not-in operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTAINS: The contains operator.
         *        </p>
         *        </li>
         * @see RuleOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOperator
         */
        Builder operator(RuleOperator operator);

        /**
         * <p>
         * The rule's value.
         * </p>
         * 
         * @param value
         *        The rule's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    private static final class BuilderImpl implements Builder {
        private String attribute;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            setAttribute(model.attribute);
            setOperator(model.operator);
            setValue(model.value);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(DeviceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleOperator operator) {
            this.operator(operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }
    }
}
