/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the update device pool operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDevicePoolRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDevicePoolRequest.Builder, UpdateDevicePoolRequest> {
    private final String arn;

    private final String name;

    private final String description;

    private final List<Rule> rules;

    private UpdateDevicePoolRequest(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The Amazon Resourc Name (ARN) of the Device Farm device pool you wish to update.
     * </p>
     * 
     * @return The Amazon Resourc Name (ARN) of the Device Farm device pool you wish to update.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * A string representing the name of the device pool you wish to update.
     * </p>
     * 
     * @return A string representing the name of the device pool you wish to update.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the device pool you wish to update.
     * </p>
     * 
     * @return A description of the device pool you wish to update.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if you choose
     * to update rules for your request, the update will replace the existing rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if you
     *         choose to update rules for your request, the update will replace the existing rules.
     */
    public List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevicePoolRequest)) {
            return false;
        }
        UpdateDevicePoolRequest other = (UpdateDevicePoolRequest) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDevicePoolRequest> {
        /**
         * <p>
         * The Amazon Resourc Name (ARN) of the Device Farm device pool you wish to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resourc Name (ARN) of the Device Farm device pool you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A string representing the name of the device pool you wish to update.
         * </p>
         * 
         * @param name
         *        A string representing the name of the device pool you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the device pool you wish to update.
         * </p>
         * 
         * @param description
         *        A description of the device pool you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if you
         * choose to update rules for your request, the update will replace the existing rules.
         * </p>
         * 
         * @param rules
         *        Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if
         *        you choose to update rules for your request, the update will replace the existing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if you
         * choose to update rules for your request, the update will replace the existing rules.
         * </p>
         * 
         * @param rules
         *        Represents the rules you wish to modify for the device pool. Updating rules is optional; however, if
         *        you choose to update rules for your request, the update will replace the existing rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevicePoolRequest model) {
            setArn(model.arn);
            setName(model.name);
            setDescription(model.description);
            setRules(model.rules);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Rule> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
        }

        @Override
        public UpdateDevicePoolRequest build() {
            return new UpdateDevicePoolRequest(this);
        }
    }
}
