/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.DeviceAttribute;
import software.amazon.awssdk.services.devicefarm.transform.IncompatibilityMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IncompatibilityMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, IncompatibilityMessage> {
    private final String message;
    private final String type;

    private IncompatibilityMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.type = builder.type;
    }

    public String message() {
        return this.message;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncompatibilityMessage)) {
            return false;
        }
        IncompatibilityMessage other = (IncompatibilityMessage)obj;
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IncompatibilityMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String message;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IncompatibilityMessage model) {
            this.setMessage(model.message);
            this.setType(model.type);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceAttribute type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public IncompatibilityMessage build() {
            return new IncompatibilityMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IncompatibilityMessage> {
        public Builder message(String var1);

        public Builder type(String var1);

        public Builder type(DeviceAttribute var1);
    }
}

