/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Suite;
import software.amazon.awssdk.services.devicefarm.model.SuitesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSuitesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSuitesResponse> {
    private final List<Suite> suites;
    private final String nextToken;

    private ListSuitesResponse(BuilderImpl builder) {
        this.suites = builder.suites;
        this.nextToken = builder.nextToken;
    }

    public List<Suite> suites() {
        return this.suites;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.suites() == null ? 0 : this.suites().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuitesResponse)) {
            return false;
        }
        ListSuitesResponse other = (ListSuitesResponse)((Object)obj);
        if (other.suites() == null ^ this.suites() == null) {
            return false;
        }
        if (other.suites() != null && !other.suites().equals(this.suites())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.suites() != null) {
            sb.append("Suites: ").append(this.suites()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Suite> suites;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuitesResponse model) {
            this.setSuites(model.suites);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Suite> getSuites() {
            return this.suites;
        }

        @Override
        public final Builder suites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Suite ... suites) {
            this.suites(Arrays.asList(suites));
            return this;
        }

        public final void setSuites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListSuitesResponse build() {
            return new ListSuitesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSuitesResponse> {
        public Builder suites(Collection<Suite> var1);

        public Builder suites(Suite ... var1);

        public Builder nextToken(String var1);
    }
}

