/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ResolutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Resolution
implements StructuredPojo,
ToCopyableBuilder<Builder, Resolution> {
    private final Integer width;
    private final Integer height;

    private Resolution(BuilderImpl builder) {
        this.width = builder.width;
        this.height = builder.height;
    }

    public Integer width() {
        return this.width;
    }

    public Integer height() {
        return this.height;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.width() == null ? 0 : this.width().hashCode());
        hashCode = 31 * hashCode + (this.height() == null ? 0 : this.height().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resolution)) {
            return false;
        }
        Resolution other = (Resolution)obj;
        if (other.width() == null ^ this.width() == null) {
            return false;
        }
        if (other.width() != null && !other.width().equals(this.width())) {
            return false;
        }
        if (other.height() == null ^ this.height() == null) {
            return false;
        }
        return other.height() == null || other.height().equals(this.height());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.width() != null) {
            sb.append("Width: ").append(this.width()).append(",");
        }
        if (this.height() != null) {
            sb.append("Height: ").append(this.height()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResolutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer width;
        private Integer height;

        private BuilderImpl() {
        }

        private BuilderImpl(Resolution model) {
            this.setWidth(model.width);
            this.setHeight(model.height);
        }

        public final Integer getWidth() {
            return this.width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public final Integer getHeight() {
            return this.height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public Resolution build() {
            return new Resolution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Resolution> {
        public Builder width(Integer var1);

        public Builder height(Integer var1);
    }
}

