/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNetworkProfileRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateNetworkProfileRequest.Builder, CreateNetworkProfileRequest> {
    private final String projectArn;

    private final String name;

    private final String description;

    private final String type;

    private final Long uplinkBandwidthBits;

    private final Long downlinkBandwidthBits;

    private final Long uplinkDelayMs;

    private final Long downlinkDelayMs;

    private final Long uplinkJitterMs;

    private final Long downlinkJitterMs;

    private final Integer uplinkLossPercent;

    private final Integer downlinkLossPercent;

    private CreateNetworkProfileRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The name you wish to specify for the new network profile.
     * </p>
     * 
     * @return The name you wish to specify for the new network profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the network profile.
     * </p>
     * 
     * @return The description of the network profile.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of network profile you wish to create. Valid values are listed below.
     * </p>
     * 
     * @return The type of network profile you wish to create. Valid values are listed below.
     * @see NetworkProfileType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * </p>
     * 
     * @return The data throughput rate in bits per second, as an integer from 0 to 104857600.
     */
    public Long uplinkBandwidthBits() {
        return uplinkBandwidthBits;
    }

    /**
     * <p>
     * The data throughput rate in bits per second, as an integer from 0 to 104857600.
     * </p>
     * 
     * @return The data throughput rate in bits per second, as an integer from 0 to 104857600.
     */
    public Long downlinkBandwidthBits() {
        return downlinkBandwidthBits;
    }

    /**
     * <p>
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     */
    public Long uplinkDelayMs() {
        return uplinkDelayMs;
    }

    /**
     * <p>
     * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
     */
    public Long downlinkDelayMs() {
        return downlinkDelayMs;
    }

    /**
     * <p>
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     */
    public Long uplinkJitterMs() {
        return uplinkJitterMs;
    }

    /**
     * <p>
     * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     * </p>
     * 
     * @return Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
     */
    public Long downlinkJitterMs() {
        return downlinkJitterMs;
    }

    /**
     * <p>
     * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     * </p>
     * 
     * @return Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
     */
    public Integer uplinkLossPercent() {
        return uplinkLossPercent;
    }

    /**
     * <p>
     * Proportion of received packets that fail to arrive from 0 to 100 percent.
     * </p>
     * 
     * @return Proportion of received packets that fail to arrive from 0 to 100 percent.
     */
    public Integer downlinkLossPercent() {
        return downlinkLossPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((projectArn() == null) ? 0 : projectArn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((uplinkBandwidthBits() == null) ? 0 : uplinkBandwidthBits().hashCode());
        hashCode = 31 * hashCode + ((downlinkBandwidthBits() == null) ? 0 : downlinkBandwidthBits().hashCode());
        hashCode = 31 * hashCode + ((uplinkDelayMs() == null) ? 0 : uplinkDelayMs().hashCode());
        hashCode = 31 * hashCode + ((downlinkDelayMs() == null) ? 0 : downlinkDelayMs().hashCode());
        hashCode = 31 * hashCode + ((uplinkJitterMs() == null) ? 0 : uplinkJitterMs().hashCode());
        hashCode = 31 * hashCode + ((downlinkJitterMs() == null) ? 0 : downlinkJitterMs().hashCode());
        hashCode = 31 * hashCode + ((uplinkLossPercent() == null) ? 0 : uplinkLossPercent().hashCode());
        hashCode = 31 * hashCode + ((downlinkLossPercent() == null) ? 0 : downlinkLossPercent().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkProfileRequest)) {
            return false;
        }
        CreateNetworkProfileRequest other = (CreateNetworkProfileRequest) obj;
        if (other.projectArn() == null ^ this.projectArn() == null) {
            return false;
        }
        if (other.projectArn() != null && !other.projectArn().equals(this.projectArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.uplinkBandwidthBits() == null ^ this.uplinkBandwidthBits() == null) {
            return false;
        }
        if (other.uplinkBandwidthBits() != null && !other.uplinkBandwidthBits().equals(this.uplinkBandwidthBits())) {
            return false;
        }
        if (other.downlinkBandwidthBits() == null ^ this.downlinkBandwidthBits() == null) {
            return false;
        }
        if (other.downlinkBandwidthBits() != null && !other.downlinkBandwidthBits().equals(this.downlinkBandwidthBits())) {
            return false;
        }
        if (other.uplinkDelayMs() == null ^ this.uplinkDelayMs() == null) {
            return false;
        }
        if (other.uplinkDelayMs() != null && !other.uplinkDelayMs().equals(this.uplinkDelayMs())) {
            return false;
        }
        if (other.downlinkDelayMs() == null ^ this.downlinkDelayMs() == null) {
            return false;
        }
        if (other.downlinkDelayMs() != null && !other.downlinkDelayMs().equals(this.downlinkDelayMs())) {
            return false;
        }
        if (other.uplinkJitterMs() == null ^ this.uplinkJitterMs() == null) {
            return false;
        }
        if (other.uplinkJitterMs() != null && !other.uplinkJitterMs().equals(this.uplinkJitterMs())) {
            return false;
        }
        if (other.downlinkJitterMs() == null ^ this.downlinkJitterMs() == null) {
            return false;
        }
        if (other.downlinkJitterMs() != null && !other.downlinkJitterMs().equals(this.downlinkJitterMs())) {
            return false;
        }
        if (other.uplinkLossPercent() == null ^ this.uplinkLossPercent() == null) {
            return false;
        }
        if (other.uplinkLossPercent() != null && !other.uplinkLossPercent().equals(this.uplinkLossPercent())) {
            return false;
        }
        if (other.downlinkLossPercent() == null ^ this.downlinkLossPercent() == null) {
            return false;
        }
        if (other.downlinkLossPercent() != null && !other.downlinkLossPercent().equals(this.downlinkLossPercent())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (projectArn() != null) {
            sb.append("ProjectArn: ").append(projectArn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (uplinkBandwidthBits() != null) {
            sb.append("UplinkBandwidthBits: ").append(uplinkBandwidthBits()).append(",");
        }
        if (downlinkBandwidthBits() != null) {
            sb.append("DownlinkBandwidthBits: ").append(downlinkBandwidthBits()).append(",");
        }
        if (uplinkDelayMs() != null) {
            sb.append("UplinkDelayMs: ").append(uplinkDelayMs()).append(",");
        }
        if (downlinkDelayMs() != null) {
            sb.append("DownlinkDelayMs: ").append(downlinkDelayMs()).append(",");
        }
        if (uplinkJitterMs() != null) {
            sb.append("UplinkJitterMs: ").append(uplinkJitterMs()).append(",");
        }
        if (downlinkJitterMs() != null) {
            sb.append("DownlinkJitterMs: ").append(downlinkJitterMs()).append(",");
        }
        if (uplinkLossPercent() != null) {
            sb.append("UplinkLossPercent: ").append(uplinkLossPercent()).append(",");
        }
        if (downlinkLossPercent() != null) {
            sb.append("DownlinkLossPercent: ").append(downlinkLossPercent()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateNetworkProfileRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project for which you want to create a network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The name you wish to specify for the new network profile.
         * </p>
         * 
         * @param name
         *        The name you wish to specify for the new network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the network profile.
         * </p>
         * 
         * @param description
         *        The description of the network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of network profile you wish to create. Valid values are listed below.
         * </p>
         * 
         * @param type
         *        The type of network profile you wish to create. Valid values are listed below.
         * @see NetworkProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProfileType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of network profile you wish to create. Valid values are listed below.
         * </p>
         * 
         * @param type
         *        The type of network profile you wish to create. Valid values are listed below.
         * @see NetworkProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProfileType
         */
        Builder type(NetworkProfileType type);

        /**
         * <p>
         * The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * </p>
         * 
         * @param uplinkBandwidthBits
         *        The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkBandwidthBits(Long uplinkBandwidthBits);

        /**
         * <p>
         * The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * </p>
         * 
         * @param downlinkBandwidthBits
         *        The data throughput rate in bits per second, as an integer from 0 to 104857600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkBandwidthBits(Long downlinkBandwidthBits);

        /**
         * <p>
         * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param uplinkDelayMs
         *        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkDelayMs(Long uplinkDelayMs);

        /**
         * <p>
         * Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param downlinkDelayMs
         *        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkDelayMs(Long downlinkDelayMs);

        /**
         * <p>
         * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param uplinkJitterMs
         *        Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkJitterMs(Long uplinkJitterMs);

        /**
         * <p>
         * Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * </p>
         * 
         * @param downlinkJitterMs
         *        Time variation in the delay of received packets in milliseconds as an integer from 0 to 2000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkJitterMs(Long downlinkJitterMs);

        /**
         * <p>
         * Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * </p>
         * 
         * @param uplinkLossPercent
         *        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkLossPercent(Integer uplinkLossPercent);

        /**
         * <p>
         * Proportion of received packets that fail to arrive from 0 to 100 percent.
         * </p>
         * 
         * @param downlinkLossPercent
         *        Proportion of received packets that fail to arrive from 0 to 100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkLossPercent(Integer downlinkLossPercent);
    }

    private static final class BuilderImpl implements Builder {
        private String projectArn;

        private String name;

        private String description;

        private String type;

        private Long uplinkBandwidthBits;

        private Long downlinkBandwidthBits;

        private Long uplinkDelayMs;

        private Long downlinkDelayMs;

        private Long uplinkJitterMs;

        private Long downlinkJitterMs;

        private Integer uplinkLossPercent;

        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkProfileRequest model) {
            setProjectArn(model.projectArn);
            setName(model.name);
            setDescription(model.description);
            setType(model.type);
            setUplinkBandwidthBits(model.uplinkBandwidthBits);
            setDownlinkBandwidthBits(model.downlinkBandwidthBits);
            setUplinkDelayMs(model.uplinkDelayMs);
            setDownlinkDelayMs(model.downlinkDelayMs);
            setUplinkJitterMs(model.uplinkJitterMs);
            setDownlinkJitterMs(model.downlinkJitterMs);
            setUplinkLossPercent(model.uplinkLossPercent);
            setDownlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getUplinkBandwidthBits() {
            return uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        public final Long getDownlinkBandwidthBits() {
            return downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        public final Long getUplinkDelayMs() {
            return uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        public final Long getDownlinkDelayMs() {
            return downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        public final Long getUplinkJitterMs() {
            return uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        public final Long getDownlinkJitterMs() {
            return downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        public final Integer getUplinkLossPercent() {
            return uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        public final Integer getDownlinkLossPercent() {
            return downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        @Override
        public CreateNetworkProfileRequest build() {
            return new CreateNetworkProfileRequest(this);
        }
    }
}
